#include "EthernetNetIf.h"
#include "SimpleSocket.h"

void echoclient() {
    EthernetNetIf eth;
    eth.setup();

    printf("Echo server => ");
    char server[32];
    scanf("%s", server);

    ClientSocket socket(server, 1234);

    if (socket) {
        char message[80] = {};
        printf("Enter message => ");
        int c = 0;
        while (c < ' ' || 0x7E < c)
            c = getc(stdin);
        ungetc(c, stdin);
        for (int i = 0; i < sizeof(message) - 1 && (c = getc(stdin)) >= ' '; i++)
            message[i] = c;

        socket.printf("%s", message);

        // wait until data is received
        while (!socket.available())
            ;
        printf("Received: ");

        while (socket.available()) {
            char buf[128];
            int len = socket.read(buf, sizeof(buf) - 1);
            buf[len] = '\0';
            printf("%s", buf);
        }
        printf("\nClosing...\n");
        socket.close();
    }
    printf("Done.\n");
}