#include "EthernetNetIf.h"
#include "SimpleSocket.h"

void webcontroller() {
    const char *response0 =
        "HTTP/1.1 200 OK\r\n"
        "Content-Type: text/html\r\n"
        "\r\n"
        "<html>\n"
        "<head><title>mbed LED1 Controller</title></head>\n"
        "<body>\n"
        "<h4>LED1 Status & Change</h4>\n";

    const char *response1 =
        "<form method=\"GET\" action=\"/\">\n"
        "<input type=\"radio\" name=\"LED\" value=\"1\" %s onclick=\"submit();\"/>ON\n"
        "<input type=\"radio\" name=\"LED\" value=\"0\" %s onclick=\"submit();\"/>OFF\n"
        "</form>\n";
    const char *response2 =
        "</body>\n"
        "</html>\n";

    DigitalOut led1(LED1);
    EthernetNetIf eth;
    eth.setup();

    ServerSocket server(80);

    while (true) {
        ClientSocket socket = server.accept();
        while (socket) {
            if (socket.available()) {
                char buf[512] = {};
                socket.read(buf, sizeof(buf) - 1);
                printf("\n%s\n", buf);
                led1 = strncmp("GET /?LED=1", buf, 11) == 0;

                printf("LED1 = %d\n\n", led1.read());
                printf(response0);
                printf(response1, led1 ? "checked" : "", led1 ? "" : "checked");
                printf(response2);

                socket.printf(response0);
                socket.printf(response1, led1 ? "checked" : "", led1 ? "" : "checked");
                socket.printf(response2);
                socket.close();
            }
        }
    }
}