#include "mbed.h"
#include "SCP1000.h"

DigitalIn sw(p9);
DigitalOut leds[4] = {LED1, LED2, LED3, LED4};
SCP1000 scp1000(p5, p6, p7, p8);
LocalFileSystem local("local");
void printMeasurements(char *title, int n);

int main() {
    char buf[32];
    
    for (int i = 0; !sw; i = (i + 1) % 8) {
        leds[i < 4 ? i : 7 - i] = 1;
        wait(0.05);
        leds[i < 4 ? i : 7 - i] = 0;
    }

    FILE *fp = fopen("/local/scp1000.txt", "a");
    if (fp == NULL) exit(-1);

    time_t seconds = time(NULL);
    strftime(buf, sizeof(buf), "%x %X", localtime(&seconds));
    fprintf(fp, "Time: %s\n", buf);
    fprintf(fp, "SCP1000 ASIC revision number = %d\n", scp1000.revision());
    bool result = scp1000.performSelfTest();
    fprintf(fp, "SCP1000 self test: %s\n", result ? "PASSED" : "FAILED");
    fprintf(fp, "SCP1000 reset\n");
    scp1000.reset();
    fclose(fp);

    scp1000.setOperationMode(SCP1000::HIGH_SPEED_MODE);
    printMeasurements("SCP1000 High Speed Mode - 9Hz", 3600 * 9);

    scp1000.setOperationMode(SCP1000::HIGH_RESOLUTION_MODE);
    printMeasurements("SCP1000 High Resolution Mode - 1.8Hz",  3600 * 9 / 5);

    scp1000.setOperationMode(SCP1000::ULTRA_LOW_POWER_MODE);
    printMeasurements("SCP1000 Ultra Low Power Mode - 1Hz", 3600 * 10);
}

void printMeasurements(char *title, int n) {
    FILE *fp = fopen("/local/scp1000.txt", "a");
    fprintf(fp, "%s\n", title);

    for (int i = 0; !sw && i < n; i++) {
        while (!scp1000.isReady())
            ;
        time_t seconds = time(NULL);
        char buf[16];
        strftime(buf, sizeof(buf), "%X", localtime(&seconds));
        fprintf(fp, "%s %3.2f, %3.3f\n", buf, scp1000.readTemperature(), scp1000.readPressure());
        leds[i % 4] = (i % 8) < 4;
        if (i % 100 == 99) {
            fclose(fp);
            fp = fopen("/local/scp1000.txt", "a");
        }
    }

    fclose(fp);
    wait(1.0);
}