#include "Player.h"

#define min(x, y) ((x) < (y) ? (x) : (y))

Player::Player(char *s1, char *s2, char *s3) {
    MusicString ms1(s1);
    MusicString ms2(s2);
    MusicString ms3(s3);
    layer1 = Layer(ms1);
    layer2 = Layer(ms2);
    layer3 = Layer(ms3);
}

void Player::play(YMZ294& soundGen, int freq, int shape, int tempo) {
    bool attenuate = (shape < 8|| shape == 9 || shape == 15);
    for (int tick = 0, dur = 0;; tick += dur) {
        dur = layer1.play(soundGen, CHANNEL_A, tick, attenuate);
        if (!layer2.isNull()) {
            int dur2 = layer2.play(soundGen, CHANNEL_B, tick, attenuate);
            dur = min(dur, dur2);
        }
        if (!layer3.isNull()) {
            int dur3 = layer3.play(soundGen, CHANNEL_C, tick, attenuate);
            dur = min(dur, dur3);
        }
        if (dur == 0)
            break;
        soundGen.setEnvelope(freq, shape);
        soundGen.setMixer(TONE_A, TONE_B, TONE_C);
        wait(dur / 480.0 * 60.0 / tempo);
    }
    soundGen.setMixer(NONE);
    soundGen.setVolume(CHANNEL_A, 0);
    soundGen.setVolume(CHANNEL_B, 0);
    soundGen.setVolume(CHANNEL_C, 0);
}

void Player::rewind() {
    layer1.rewind();
    layer2.rewind();
    layer3.rewind();
}
