#include "Note.h"

int const WHOLE = 1920;

Note::Note(int pitch, int dur, bool tie) {
    this->pitch = pitch;
    this->dur = dur;
    this->tie = tie;
}

Note::Note(const char* s) {
    char c = *s;
    pitch = ('A' <= c && c <= 'G') ? (5 * (c - 'A') + 1) / 3 : -1;

    if (pitch != -1) {
        c = *++s;
        while (c < '0' || '9' < c) {
            if (c == '#') {
                pitch++;
            } else if (c == 'b') {
                pitch--;
            }
            c = *++s;
        }
        if (pitch < 3) {
            pitch += 12;
        }
        pitch += (c - '0') * 12 + 9;
    } else {
        pitch = 0;
    }

    s++;
    dur = 0;
    tie = false;
    while (*s) {
        switch (*s++) {
            case 'w':
                dur += WHOLE; //whole note
                break;
            case 'h':
                dur += WHOLE / 2; // half note
                break;
            case 'q':
                dur += WHOLE / 4; // quarter
                break;
            case 'i':
                dur += WHOLE / 8; // eighth
                break;
            case 's':
                dur += WHOLE / 16; // sixteenth
                break;
            case 't':
                dur += WHOLE / 32; // thirty-second
                break;
            case 'x':
                dur += WHOLE / 64; // sixty-fourth
                break;
            case 'o':
                dur += WHOLE / 128; // one-twenty-eighth
                break;
            case '.': // dot - only single . is supported
                dur += dur / 2;
                break;
            case '/': // triplet
                dur = dur * 2 / 3;
                break;
            case '-':
            case '_':
                tie = true;
                break;
        }
    }
}