#include "MusicString.h"

MusicString::MusicString(const char *s) : mstring(s), current(s) {
}

MusicString::MusicString(const MusicString& ms) : mstring(ms.mstring), current(ms.mstring) {
}

bool MusicString::isNull() {
    return current == 0;
}

void MusicString::rewind() {
    current = mstring;
}

Note MusicString::getNextNote() {
    if (hasMoreNote()) {
        char buf[16];
        int i = 0;
        do {
            buf[i++] = *current++;
        } while (*current && *current > ' ' && *current != '|' && *current != '(' && *current != ')');
        buf[i] = 0;
        return Note(buf);
    } else
        return Note();
}

bool MusicString::hasMoreNote() {
    while (*current && *current <= ' ' || *current == '|' || *current == '(' || *current == ')')
        current++;
    return (*current);
}