#include "Layer.h"

Layer::Layer() {}

Layer::Layer(MusicString& ms) : ms(ms), note(), tick(0) {}

int Layer::play(YMZ294& soundGen, Channel channel, int tick, bool attenuate) {
    note.dur -= tick - this->tick;
    this->tick = tick;

    if (note.dur == 0) {
        if (ms.hasMoreNote()) {
            note = ms.getNextNote();
            while (note.tie && ms.hasMoreNote()) {
                Note note2 = ms.getNextNote();
                note.dur += note2.dur;
                note.tie = note2.tie;
            }

            if (note.pitch != 0) {
                float freq = 30.8677 * pow(1.059463, note.pitch - 23);
                soundGen.setVolume(channel, 16);
                soundGen.setTone(channel, freq);
            } else {
                if (attenuate)
                    soundGen.setVolume(channel, 0);
            }
        }
    } else {
        soundGen.setVolume(channel, 0);
    }

    return note.dur;
}

void Layer::rewind() {
    ms.rewind();
    note.pitch = 0;
    note.dur = 0;
    note.tie = false;
    tick = 0;
}

bool Layer::isNull() {
    return ms.isNull();
}