#ifndef MPL115A2
#define MPL115A

#include "mbed.h"

/**
 * MPL115A2 (I2C) pressure sensor
 */

class MPL115A2 {
public:
    /**
    * Create an MPL115A(I2C) interface with specified pins
    *
    * @param PinName sda SDA pin (default = p9)
    * @param PinName scl SCL pin (default = p10)
    */
    MPL115A2(PinName sda = p9, PinName scl = p10) : i2c(sda, scl) {
    }

    /**
    * Read current pressure and/or temperature
    *
    * @param puressure pointer to a float area to receive pressure
    * @param padc pointer to an int area to receive pressure adc value
    * @param tadc pointer to an int area to receive temperature adc value
    * @param data pointer to an array of adc's and coefficients (byte array of size 16)
    *
    * @returns 0 (success), or -1 (I2C error)
    */

    int read(float *pressure, char *data);
    
    /**
    * Read current pressure
    *
    * @returns current pressure (in hPa)
    */
    float readPressure();

    /**
    * Operator shorthand for readPressure()
    */
    operator float() {
        return readPressure();
    }

private:
    I2C i2c;
};

#endif