#include "mbed.h"
#include "MMA7361L.h"

MMA7361L accel(p15, p16, p17, p25, p26, p24); // x, y, z, 0g, g-select, sleep

void atZeroG() {
    static BusOut leds(LED1, LED2, LED3, LED4);

    leds = 15;
    printf("atZeroG %4.3f: %4.3f, %4.3f, %4.3f\n",
           accel.getAccel(), accel.getAccelX(), accel.getAccelY(), accel.getAccelZ());
    wait(1);
    leds = 0;
}

inline float toDegrees(float r) {
    return 180 * r / 3.14159;
}

int main() {
    accel.printInfo();
    accel.setZeroGDetectListener(atZeroG);
    accel.setScale(MMA7361L::SCALE_1_5G);
    accel.calibrate(MMA7361L::SCALE_1_5G, -1, 1, -1, 1, -1, 1);
    
    while (true) {
        printf("Accel %4.3f: %4.3f, %4.3f, %4.3f, %2.0f, %2.0f, %2.0f\n",
               accel.getAccel(), accel.getAccelX(), accel.getAccelY(), accel.getAccelZ(),
               toDegrees(accel.getTiltX()), toDegrees(accel.getTiltY()), toDegrees(accel.getTiltZ()));
        wait(5);
    }
}