#include "Accelerometer.h"

Accelerometer::Accelerometer(PinName xPin, PinName yPin,PinName zPin, PinName slpPin, PinName  gs1Pin, PinName gs2Pin) :
        xout(xPin), yout(yPin), zout(zPin), gs1(gs1Pin), gs2(gs2Pin), sleep(slpPin) {
    sleep = 1; // normal mode
    gs1 = 0; // 1.5G mode
    gs2 = 0; // 1.5G mode
    scale = 0.8;
}

float Accelerometer::getAccel() {
    float x = getAccelX();
    float y = getAccelY();
    float z = getAccelZ();
    return sqrt(x * x + y * y + z * z);
}

float Accelerometer::getAccelX() {
    return ((xout * 3.3) - 1.65) / scale;
}

float Accelerometer::getAccelY() {
    return ((yout * 3.3) - 1.65) / scale;
}

float Accelerometer::getAccelZ() {
    return ((zout * 3.3) - 1.65) / scale;
}

float Accelerometer::getTiltX() {
    float x = getAccelX();
    float y = getAccelY();
    float z = getAccelZ();
    float a =  sqrt(x * x + y * y + z * z);
    return asin(x / a);
}

float Accelerometer::getTiltY() {
    float x = getAccelX();
    float y = getAccelY();
    float z = getAccelZ();
    float a =  sqrt(x * x + y * y + z * z);
    return asin(y / a);
}

float Accelerometer::getTiltZ() {
    float x = getAccelX();
    float y = getAccelY();
    float z = getAccelZ();
    float a =  sqrt(x * x + y * y + z * z);
    return asin(z / a);
}

void Accelerometer::setScale(Scale scale) {
    switch (scale) {
        case SCALE_1_5G:
            this->scale = 0.8;
            gs1 = gs2 = 0;
            break;
        case SCALE_2G:
            this->scale = 0.6;
            gs1 = 1; gs2 = 0;
            break;
        case SCALE_4G:
            this->scale = 0.3;
            gs1 = 0; gs2 = 1;
            break;
        case SCALE_6G:
            this->scale = 0.2;
            gs1 = gs2 = 1;
            break;
    }
}

void Accelerometer::setSleep(bool on) {
    sleep = !on;
}