#include "LSM303DLH.h"

LSM303DLH lsm(p28, p27, p23, p22);

void int1Detected() {
    printf("INT1 detected\n");
}

void int2Detected() {
    printf("INT2 detected\n");
}
/*
* AOI AND 1 0
* 6D  6D  0 0
* ZH      0 1
* ZL      1 0
* YH      0 1
* YL      1 0
* XH      0 1
* XL      1 0
*/
int main() {
    lsm.attach(INT1, 0x95, 31, 3, int1Detected);
    lsm.attach(INT2, 0x2A, 127, 3, int2Detected);
    while (true) {
        if (lsm.read()) {
            printf("acc: (%f, %f, %f), mag: (%f, %f, %f)\n", lsm.ax, lsm.ay, lsm.az, lsm.mx, lsm.my, lsm.mz);
            printf("direction = %.0f\n", lsm.getHeading() * 180 / 3.14159265358979);
        }
        wait(5);
    }
}