#ifndef LSM303DLH_H
#define LSM303DLH_H

#include "mbed.h"

/**/
enum ACC_ODR {
    ACC_ODR_50HZ = 0,
    ACC_ODR_100HZ = 1,
    ACC_ODR_400HZ = 2,
    ACC_ODR_1000HZ = 3,
};

enum ACC_RANGE {
    ACC_RANGE_2G = 0,
    ACC_RANGE_4G = 1,
    ACC_RANGE_8G = 3,
};

enum MAG_ODR {
    MAG_ODR_0_75HZ = 0,
    MAG_ODR_1_5HZ = 1,
    MAG_ODR_3_0HZ = 2,
    MAG_ODR_7_5HZ = 3,
    MAG_ODR_15HZ = 4,
    MAG_ODR_30HZ = 5,
    MAG_ODR_75HZ = 6,
};

enum MAG_RANGE {
    MAG_RANGE_1_3GAUSS = 1,
    MAG_RANGE_1_9GAUSS = 2,
    MAG_RANGE_2_5GAUSS = 3,
    MAG_RANGE_4_0GAUSS = 4,
    MAG_RANGE_4_7GAUSS = 5,
    MAG_RANGE_5_6GAUSS = 6,
    MAG_RANGE_8_1GAUSS = 7,
};

enum INT_TYPE {INT1, INT2};

class LSM303DLH {
public:
    float ax, ay, az;
    float mx, my, mz;

    LSM303DLH(PinName sda = p9, PinName scl = p10, PinName int1 = NC, PinName int2 = NC);
    bool setOutputDataRate(ACC_ODR acc_odr, MAG_ODR mag_odr);
    bool setMeasurementRange(ACC_RANGE acc_range, MAG_RANGE mag_range);
    bool read();
    bool read(float *ax, float *ay, float *az, float *mx, float *my, float *mz);
    float getHeading();
    float getHeading(float x, float y, float z);
    void attach(INT_TYPE type, char config, char threshold, char duration, void (*handler)(void));
    template<typename T> void attach(T *t, INT_TYPE type, char config, char threshold, char duration, void (*handler)(void));

private:
    I2C i2c;
    int acc_range, mag_range;
    InterruptIn int1, int2;

    bool recv(char sad, char sub, char *buf, int length);
    bool send(char sad, char sub, char data);
};

#endif