#ifndef VECTOR_H
#define VECTOR_H

#include "mbed.h"

class Vector {
public:
    float x, y, z;
    
    Vector(): x(0), y(0), z(0) {}
    
    Vector(float x, float y, float z) : x(x), y(y), z(z) {}
    
    Vector(const Vector& v) {
        x = v.x, y = v.y, z = v.z;
    }

    Vector product(const Vector& v) {
        return Vector(y * v.z - z * v.y, z * v.x - x * v.z, x * v.y - y * v.x);
    }

    float dot(const Vector& v) {
        return x * v.x + y * v.y + z * v.z;
    }

    Vector scale(const float c) {
        return Vector(c * x, c * y, c * z);
    }

    float norm() {
        return sqrt(x * x + y * y + z * z);
    }

    Vector operator*(const Vector& v) {
        return product(v);
    }

    Vector operator /=(float c) {
        return *this = scale(1 / c);
    }

    Vector operator *=(float c) {
        return *this = scale(c);
    }
};

#endif