#include "mbed.h"
#include "Accelerometer.h"
float toDegree(float radian) {
    return radian * 180 / 3.14159265359;
}
int main() {
    Accelerometer accel(p18, p19, p20, p23, p22, p21); // x, y, z, gs1, gs2, slp
    accel.setScale(Accelerometer::SCALE_6G);

    while (true) {
        printf("accel = %5.3f, accelX = %5.3f, accelY = %5.3f, accelZ = %5.3f\n",
               accel.getAccel(), accel.getAccelX(), accel.getAccelY(), accel.getAccelZ());
        printf("               tiltX  = %5.3f, tiltY  = %5.3f, tiltZ  = %5.3f\n",
               toDegree(accel.getTiltX()), toDegree(accel.getTiltY()), toDegree(accel.getTiltZ()));
        wait(1.0);
    }
}