#include "uv_robot.h"

UVRobot::UVRobot():_can(),_plc(),_rs485(),
_wheel(&_can, &_plc), _topLamp(2, 0x01, &_plc, &_rs485), _bottomLamp(3, &_plc), _footLamp(4, &_plc),
_enable(enablePin, &_plc), _error(errorSigPin, &_plc), _emgSW(emgSigPin, &_plc){}

enum state UVRobot::getState(){
    return _robotState;
}

void UVRobot::setState( enum state robotState ){
    _robotState = robotState;
}

void UVRobot::init(){
    setState( Init );
    _enable = 0;
    _error = 0;
    _wheel.init();
    _topLamp.init();
    _bottomLamp.init();
    _footLamp.init();
    setState( Idle );
}

void UVRobot::start(){
    _robotState = Run;
    std_msgs::Bool  sMsg;
    std_msgs::Float32MultiArray  rMsg;
    bool enFlag = 0;
    /* 
    * rMsg.data[0] : Right Wheel RPM
    * rMsg.data[1] : Left Wheel RPM
    * rMsg.data[2] : Top Lamp On/Off (On:1 Off:0)
    * rMsg.data[3] : Top Lamp Angle
    * rMsg.data[4] : Bottom Lamp On/Off (On:1 Off:0)
    * rMsg.data[5] : Foot Lamp On/Off (On:1 Off:0)
    * rMsg.data[6] : State Signal (Stop:0 Run:1 Error:2 Reset:3)
    */
    
    while(1){
        
        _RosI._nh.spinOnce();
        rMsg = _RosI.readMsg();
        
        switch((int)rMsg.data[6]){
            case 0:
                UVRobot::stop();
                enFlag = 0;
                break;
            
            case 1:
                if(enFlag == 0){ _enable = 1; enFlag = 1; wait_ms(500);}
                _wheel.setVelocity( rMsg.data[0], rMsg.data[1] );
                _topLamp.setUVPower( (uint8_t)rMsg.data[2] );
                _topLamp.setLightAngle( rMsg.data[3] );
                _bottomLamp.setUVPower( (uint8_t)rMsg.data[4] );
                _footLamp.setUVPower( (uint8_t)rMsg.data[5] );
        
                _wheel.drive();
                _topLamp.drive();
                break;
            
            case 2:
                enFlag = 0;
                UVRobot::error();
                break;
            
            default:
                enFlag = 0;
                UVRobot::stop();
                break;                
        }
                
        sMsg.data = _emgSW;
        _RosI.sendMsg(sMsg);
        if( _emgSW || (_wheel.getBatteryVoltage() < 22.0) ){
            UVRobot::error();
        }
        
        wait_ms(5);
    }
}

void UVRobot::stop(){
    _enable = 0;
    _wheel.stop();
    _topLamp.stop();
    _bottomLamp.setUVPower(0);
    _footLamp.setUVPower(0);
}

void UVRobot::error(){
    std_msgs::Float32MultiArray  rMsg;
    while(1){
        _enable = 0;
        _error = 1;
        _wheel.brake();
        _topLamp.stop();
        _bottomLamp.setUVPower(0);
        _footLamp.setUVPower(0);
        _robotState = Error;
        _RosI._nh.spinOnce();
        rMsg = _RosI.readMsg();
        if(rMsg.data[6] == 3){ break; }
    }
}