#include "uv_lamp.h"

/**
 * @brief  Constractor of UVLamp class
 * @param  pCanController: Address of CAN controller
 * @param  pPlcController: Address of PLC controller
*/
UVLamp::UVLamp( uint8_t pinNum, PLCController *pPlcController ):_uvLamp(pinNum, pPlcController), _lampState(0){}

/**
 * @brief  Toggle a lamp
 * @param  None
 * @retval None
*/
void UVLamp::toggle(){
    _lampState = !_lampState;
    _uvLamp = _lampState;
}

/**
 * @brief  Get lamp state
 * @param  None
 * @retval 1:ON 0:OFF
*/
bool UVLamp::getState(){
    return _lampState;
}

/**
 * @brief  Turn a lamp ON
 * @param  None
 * @retval None
*/
void UVLamp::On(){
    _lampState = 1;
    _uvLamp = _lampState;
}

/**
 * @brief  Turn a lamp OFF
 * @param  None
 * @retval None
*/
void UVLamp::Off(){
    _lampState = 0;
    _uvLamp = _lampState;
}