#include "tilting_lamp_module.h"

TiltingLampModule::TiltingLampModule(uint8_t LampPin, uint8_t tiltMotorID, PLCController *pPlcController, RS485Controller *pRS485Controller)
:LampModule(LampPin, pPlcController), _tiltMotor(tiltMotorID, pRS485Controller){}

void TiltingLampModule::init(){
    LampModule::init();
    _tiltMotor.motorInit();
    _tiltMotor.setLimit(UpLimitAngle, DownLimitAngle);
}

void TiltingLampModule::drive(){
    _tiltMotor.drive();
}

void TiltingLampModule::stop(){
    _tiltMotor.stop();
    _Lamp.Off();
    _uvState = 0;
}

void TiltingLampModule::setLightAngle(float lAngle){
    _tiltMotor.setAngle(lAngle);
}