#include "io24v.h"
#include "plc_controller.h"

/**
 * @brief  Initialize 24V output pin
 * @param  pinNum: Target pin number
 * @param  &plcAccessor: Pointer of plc_controller
*/
DigitalOut24V::DigitalOut24V( uint8_t pinNum, PLCController *pPlcController ){
    _pinNum = pinNum;
    _pPlcController = pPlcController;
}

/**
 * @brief  Set output pin state with "=" operator
 * @param  val: Output pin state HIGH:1 or LOW:0
 * @retval None
*/
DigitalOut24V &DigitalOut24V::operator =( bool val ){
    _pPlcController->output(_pinNum, val);
    return *this;
}

/**
 * @brief  Initialize 24V output pin
 * @param  pinNum: Target pin number
 * @param  &plcAccessor: Pointer of plc_controller
*/
DigitalIn24V::DigitalIn24V( uint8_t pinNum, PLCController *pPlcController ){
    _pinNum = pinNum;
    _pPlcController = pPlcController;
}

    
/**
 * @brief  Get input pin state with "=" operator
 * @param  None
 * @retval Input pin state HIGH:1 or LOW:0
*/
DigitalIn24V::operator bool() const{
    return _pPlcController->input(_pinNum);
}