#ifndef WHEEL
#define WHEEL

#define WHEEL_DIAMETER 0.1524

#include "ms-94bzb.h"
#include "can_controller.h"
#include "io24v.h"

class Wheel{
private:
    static const uint8_t lWheelID = 0x01;
    static const uint8_t rWheelID = 0x02;
    static const uint8_t  brakePin = 7;
    
    MS_94BZB _leftWheel, _rightWheel;
    DigitalOut24V _brake;
    bool _brakeState;
public:
    Wheel(CANController *pCanController, PLCController *pPlcAccessor );
    void init();
    void drive();
    void stop();
    void setVelocity( float lVelocity, float rVelocity );
    void brake();
    float getBatteryVoltage();
};

#endif