#ifndef UV_ROBOT_H
#define UV_ROBOT_H

#include "can_controller.h"
#include "plc_controller.h"
#include "rs485_controller.h"
#include "ros_interface.h"
#include "wheel.h"
#include "lamp_module.h"
#include "tilting_lamp_module.h"
#include "foot_lamp_module.h"
#include "io24v.h"

enum state {
    Init,
    Idle,
    Run,
    Error
};

class UVRobot {
private:
    static const uint8_t  enablePin = 1;
    static const uint8_t  errorSigPin = 8;
    static const uint8_t  emgSigPin = 1;    

    enum state _robotState;
    
    CANController       _can;
    PLCController       _plc;
    RS485Controller     _rs485;
    ROSInterface        _RosI;
    
    Wheel               _wheel;
    TiltingLampModule   _topLamp;
    LampModule          _bottomLamp;
    FootLampModule      _footLamp;
    
    DigitalOut24V       _enable;
    DigitalOut24V       _error;
    DigitalIn24V        _emgSW;
    
public:
    UVRobot();
    enum state getState();
    void setState( enum state robotState );
    void init();
    void start();
    void stop();
    void error();
};

#endif