#ifndef TILTING_LAMP_MODULE_H
#define TILTING_LAMP_MODULE_H

#include "lamp_module.h"
#include "rs405cb.h"

class TiltingLampModule: public LampModule{
private:
    static const float UpLimitAngle = 45.0;
    static const float DownLimitAngle = -45.0;
    
    RS405CB _tiltMotor;
    
public:
    TiltingLampModule(uint8_t LampPin, uint8_t tiltMotorID, PLCController *pPlcAccessor, RS485Controller *pRS485Controller);
    virtual void init();
    void drive();
    void stop();
    void setLightAngle(float lAngle);
};

#endif