#ifndef ROS_INTERFACE_H
#define ROS_INTERFACE_H

#include "mbed.h"
#include <ros.h>
#include <std_msgs/Empty.h>
#include <std_msgs/Bool.h>
#include <std_msgs/Int32.h>
#include <std_msgs/Float32.h>
#include <std_msgs/Int32MultiArray.h>
#include <std_msgs/Float32MultiArray.h>

class ROSInterface{
private:
    static std_msgs::Float32MultiArray  _rMsg;
    static std_msgs::Bool  _sMsg;
    static ros::Publisher               _pub;
    
    static void messageCallback(const std_msgs::Float32MultiArray& msg_sub){
        _rMsg.data = msg_sub.data;
    }
    
    static ros::Subscriber<std_msgs::Float32MultiArray> _sub;
    
public:
    ros::NodeHandle     _nh;
    ROSInterface();
    std_msgs::Float32MultiArray readMsg();
    void sendMsg(std_msgs::Bool msg);
};

#endif