#ifndef MS94BZB_H
#define MS94BZB_H

#include "motor.h"
#include "can_controller.h"

class MS_94BZB: public Motor{
private:
    /* CAN control commands */
    static const uint16_t MOTOR_COMMAND = (0x03<<7);
    static const uint8_t DRIVE = 1<<0;
    static const uint8_t STOP  = 0<<0;
    static const uint8_t CCW   = 0<<1;
    static const uint8_t CW    = 0<<1;
    static const uint8_t SHORT = 0<<7;
    static const uint8_t FREE  = 1<<7;
    
    static const uint16_t CTL_COMMAND = (0x09<<7);
    static const uint8_t PWM_CTL = 0;
    static const uint8_t CAN_CTL = 1;
    
    static const uint16_t STATE_COMMAND_2 = (0x07<<7);

    /* Pointer of CAN controller */
    CANController *_pCanController;
    
    /* Gear ratio of the MS-94BZB gear head */
    const float _gearRatio;
    
    /* Turning speed of brush-less motor (60-3000[rmp]) */
    uint16_t _refMotorAngularVelocity;
    
    /* Turning direction (CW:0x02 CCW:0x00) */
    uint8_t DIR;
    
    /* Turning acceleration of brush-less motor (100-11,164[rpm/s])*/
    uint16_t _accel;
    
    uint16_t _voltage;
    
public:
    MS_94BZB( uint8_t motorID, CANController *pCanController);
    virtual void motorInit();
    virtual void drive();
    virtual void stop();
    virtual void free();
    void setAngularVelocity(float avel);
    void setAcceleration(uint16_t accel);
    uint16_t getInputVoltage();
};

#endif