#include "ros_interface.h"

std_msgs::Float32MultiArray                     ROSInterface::_rMsg;
std_msgs::Bool                     ROSInterface::_sMsg;
ros::Publisher                                  ROSInterface::_pub("poyon", &_sMsg);
ros::Subscriber<std_msgs::Float32MultiArray>    ROSInterface::_sub("hogen", &messageCallback);

ROSInterface::ROSInterface(){
    _nh.initNode();
    _nh.subscribe(_sub);
    _nh.advertise(_pub);
}

std_msgs::Float32MultiArray ROSInterface::readMsg(){
    return _rMsg;
}

void ROSInterface::sendMsg(std_msgs::Bool msg){
    _sMsg = msg;
    _pub.publish( &_sMsg );
}