#ifndef PLC_CONTROLLER_H
#define PLC_CONTROLLER_H

#define PINMAX 8
#define PINMIN 1

#include "XNucleoPLC01A1.h"

class PLCController{
private:
    /* SPI bus */
    SPI _spi;
    /* X_NUCLEO_PLC01A1 IO Channels Component */
    XNucleoPLC01A1 _plc;
    /* Array for input data from Digital Input Termination Device */
    uint8_t _inputArray[2]; 
    /* Array for output data to Solid State Relay */
    uint8_t _outputArray[2];
    
public:
    PLCController();
    void output(uint8_t pinNum, bool state);
    bool input(uint8_t pinNum);
};

#endif