#include "can_controller.h"

/**
 * @brief  Initialize CAN controller
 * @param  None
*/
CANController::CANController():_can1(MBED_CONF_APP_CAN1_RD, MBED_CONF_APP_CAN1_TD){
//    _NoData[0] = 'N';
//    _NoData[1] = 'o';
//    _NoData[2] = ',';
//    _NoData[3] = 'D';
//    _NoData[4] = 'a';
//    _NoData[5] = 'T';
//    _NoData[6] = 'a';
//    _NoData[7] = '.';
}

/**
 * @brief  Send CAN message
 * @param  ID: CAN ID of the target device
 * @param  msgData: Address of the message data to be sent
 * @retval 0: Transmission is successful, -1:Transmission is failed
*/
int CANController::sendMessage( uint16_t ID, char *msgData ){
    CANMessage msg(ID, msgData, 8, CANData, CANStandard);
    int successFlag = _can1.write(msg);
    if(successFlag){
        return 0;
    }else{
        return -1;
    }
}

unsigned char *CANController::recieveMessage( uint16_t ID ){
    while(_can1.read(_rmsg)){
        if(_rmsg.id == ID){
            return _rmsg.data;
        }
    }
    return _NoData;
}