//
// imu-spi.h
//
// copyright 2010 Hugh Shane
//

class ImuSpi {
private:
    const static int bufferSize = 7;
    int16_t buffer[2][bufferSize]; // ping-pong IMU data buffer
    unsigned pingpong;
    bool dataReady;
    SPI spi; 
    DigitalOut cs; 
    DigitalOut reset; 
    DigitalOut diag; 
    InterruptIn imuDataReady;
    void InitImu(void);
    void DataReadyISR(void);
    int16_t Read(char);
    void Write(char, char);        
    void TogglePingpong() {pingpong = (~pingpong) & 1U;}; 
    int16_t* GetBufferWritePtr() {return buffer[pingpong & 1U];};
public:
    ImuSpi(void);  
    void BurstRead(void);
    int16_t* GetBufferReadPtr() {return buffer[(~pingpong) & 1U];};    
    bool IsDataReady(void);
    int GetBufferSize(void) {return bufferSize*sizeof(int16_t);};
    void reinitInterrupts(void);
};