#include "mbed.h"
#include "usb-serial.h"

volatile unsigned wp, rp;
static const int outbuf_size = 128;
static const unsigned pointer_mask = 0x007fU;
char usb_outbuf[outbuf_size];
static bool overflow;
DigitalOut mydiag(p22);;

extern "C" static void txReadyISR() __irq {

    mydiag = 1;
    // If the output buffer has data, copy the head to the UART
    if (rp != wp) {
        LPC_UART0->THR = usb_outbuf[rp];
        rp = (rp+1) & pointer_mask;
    }
    
    // If the output buffer is empty, disable the transmit buffer empty 
    // interrupt
    if (rp == wp)
       LPC_UART0->IER = 0;


    mydiag = 0;
}

void usb_serial_init(void) {
    
    // init the output FIFO
    wp = 0; rp = 0;
    overflow = false;

    // init the serial port
    Serial usb_serial(USBTX, USBRX);    
    usb_serial.baud(/*115200*/230400);
    usb_serial.format(8, Serial::None, 1);
    LPC_UART0->FCR = 7UL;
    NVIC_SetVector(UART0_IRQn, (uint32_t)txReadyISR);
    NVIC_EnableIRQ(UART0_IRQn);
    LPC_UART0->THR = 0; // this is required to start the interrupts, don't understand why
}

bool usb_serial_putc(char c) {

    if (overflow == false) {
        usb_outbuf[wp] = c;      
        LPC_UART0->IER = 0; // ---- critical
        wp = (wp+1) & pointer_mask;

        if (wp == rp)
            overflow = true;
        else
            overflow = false;

        LPC_UART0->IER = 2UL;  // ---- \critical
    } else {
        // reinit the output FIFO
        wp = 0; rp = 0;
        overflow = false;
    }
    
    return overflow;
}