//
// main.cpp
//
// Container class for mbed-based ADIS16355 IMU data acquisition system
//
// copyright 2010 Hugh Shane
//
#include "mbed.h"
#include "imu-spi.h"
#include "usb-serial.h"

int main() {
    DigitalOut diag_led(LED1);          
    ImuSpi imu;
    usb_serial_init();
    char* imubuffer;
    bool overflow;
    Timer timer;
    timer.start();
    int now, last = 0, elapsed;
    int nbytes = 12;
     
    while (1) {
    
        // acquire the IMU data
        while (!imu.IsDataReady()) {} // wait for the IMU data-ready signal
        now = timer.read_us(); // grab the elapsed time in microseconds
        elapsed = now - last;
        last = now;
        imu.BurstRead(); // read the IMU output data registers
        imubuffer = (char*)imu.GetBufferReadPtr(); // get a pointer to the IMU output data
        
        // transmit a data packet on the USB serial port
        overflow = usb_serial_putc(0x55); // start of packet
        overflow = usb_serial_putc((uint8_t)elapsed); // time marker, just the lower bits
        
        for (int i = 0; i < nbytes; i++) {
            overflow = usb_serial_putc(*imubuffer++); // IMU data
        }
        
        overflow = usb_serial_putc(0xAA); // end of packet

        // diagnostic LED
        if (overflow)
            diag_led = 1;
        else
            diag_led = 0;
            
    }

}