//
// main.cpp
//
// Container class for mbed-based ADIS16355 IMU data acquisition system
//
// copyright 2010 Hugh Shane
//
#include "mbed.h"
#include "imu-spi.h"

// http://mbed.org/cookbook/Networking-Stack-Releases
#include "EthernetNetIf.h"
#include "UDPSocket.h"
 
#define NLOOPS 100
#define PORT_DONT_CARE 10000

AnalogOut signal(p18);

// mask off the flag bits 
// convert two's complement to offset binary
uint16_t fixImuData(int16_t imuData) {
    uint16_t imu16 = (imuData & 0x3fff) ^ 0x2000;
    return imu16;
}
    
int main() {

    EthernetNetIf eth(
        IpAddr(192,168,1,2), //IP Address
        IpAddr(255,255,255,0), //Network Mask
        IpAddr(192,168,1,1), //Gateway
        IpAddr(192,168,1,1)  //DNS
    );
    
    int ethErr =  eth.setup();
    
    if ( ethErr == ETH_OK ) {
        IpAddr localIp = eth.getIp();
        printf("mbed IP Address is %d.%d.%d.%d\r\n", 
            localIp[0], localIp[1], localIp[2], localIp[3]);
    } else printf ("ETHERNETSETUP FAILED\n");    
    
    Host destHost(IpAddr(192,168,1,8), 55555);
    UDPSocket udpSocket;
    UDPSocketErr udpErr = udpSocket.bind(Host(IpAddr(), PORT_DONT_CARE));
    
    if (udpErr != UDPSOCKET_OK) {
        printf("error %d\n", udpErr);
    };
     
    DigitalOut diag_led(LED1);
    ImuSpi imu;
    int16_t* imubuffer;
    int bufLength = 16;
    int bufDepth = 10; // buffer this many acq. cycles before UDP send
    char outBuf[bufLength * bufDepth];
    int nSent;

    diag_led = 0;
    
    Net::poll(); // ensure that every component of the network stack keeps running
    wait(1); // give things time to settle before commencing
    
    for (int i = 0; i < NLOOPS; i++) {    
        //while(1) {
        
            for (int n = 0; n < bufDepth; n++) {
                while (!imu.IsBufferReady()) {} // wait for the IMU buffer-ready signal
                imubuffer = imu.GetBufferReadPtr(); // get a pointer to the new IMU output data
                memcpy(&outBuf[bufLength*n] , imubuffer, bufLength);
                signal.write_u16(fixImuData(imubuffer[6])); // write to the D/A converter
            }
            
            Net::poll(); // ensure that every component of the network stack keeps running
            nSent = udpSocket.sendto((char*)outBuf,(bufLength*bufDepth),&destHost);
            
            if ( nSent <= 0 ) {
                printf("error %d\n", (UDPSocketErr)nSent);
                fflush(stdout);
                diag_led = 0;
                break;
            } else {
                diag_led = 1;
                //printf(".");
                //fflush(stdout);
            }
    
    }


}

