//
// imu-spi.h
//
// copyright 2010 Hugh Shane
//

class ImuSpi {
private:
    const static int dataSize = 7;
    const static int bufferSize = dataSize+1; // we need to leave room for one junk data
    int8_t imuRegs[bufferSize];
    int16_t buffer[2][bufferSize]; // ping-pong IMU data buffer
    int8_t pingpong;
    bool bufferReady;
    SPI spi; 
    DigitalOut cs; 
    DigitalOut reset; 
    DigitalOut diag; 
    InterruptIn imuDataReady;
    void InitImu(void);
    void IMUDataReadyISR(void);
    int16_t ReadSynch(char);
    void WriteSynch(char, char); 
    void SendReadCmd(int8_t);    
    void TogglePingpong() {pingpong = (~pingpong) & 0x01;}; 
    int16_t* GetBufferWritePtr() {return &buffer[pingpong][0];};
    volatile int imuCmdIndex;
    volatile int imuReadIndex;
    Timeout writeTrigger;
    int16_t* wp;
    void WriteTriggerTimeoutISR(void);
    void SSP0ISR(void);
    static void _ssp0isr(void);
    int sequenceNumber;
    InterruptIn onePPS;
public:
    ImuSpi(void);  
    void StartBurstRead(void);
    int16_t* GetBufferReadPtr() {return buffer[(~pingpong) & 0x01];};    
    bool IsBufferReady(void);
    int GetBufferSize(void) {return bufferSize*sizeof(int16_t);};
};