#include "keyboardJP53.h"

/*
試作版キーボード 日本語53キー版 クラス
*/

keyboardJP53::keyboardJP53()
{
    //行*列毎にキーコードを指定してkeyboardButtonを定義する
    //[参考URL] http://www2d.biglobe.ne.jp/~msyk/keyboard/layout/usbkeycode.html
    _map[0][0] = new    keyboardButton(  1, false); //半角/全角
    _map[0][1] = new    keyboardButton(110, false); //ESC
    _map[0][2] = new    keyboardButton( 17, false); //Q
    _map[0][3] = new    keyboardButton( 18, false); //W
    _map[0][4] = new    keyboardButton( 19, false); //E
    _map[0][5] = new    keyboardButton( 20, false); //R
    _map[0][6] = new    keyboardButton( 21, false); //T
    _map[0][7] = NULL;

    _map[1][0] = new    keyboardButton(22, false);  //Y
    _map[1][1] = new    keyboardButton(23, false);  //U
    _map[1][2] = new    keyboardButton(24, false);  //I
    _map[1][3] = new    keyboardButton(25, false);  //O
    _map[1][4] = new    keyboardButton(26, false);  //P
    _map[1][5] = new    keyboardButton(12, false);  //-
    _map[1][6] = new    keyboardButton(15, false);  //BackSpace
    _map[1][7] = NULL;

    _map[2][0] = new    keyboardButton(16, false);  //TAB
    _map[2][1] = new    keyboardButton(31, false);  //A
    _map[2][2] = new    keyboardButton(32, false);  //S
    _map[2][3] = new    keyboardButton(33, false);  //D
    _map[2][4] = new    keyboardButton(34, false);  //F
    _map[2][5] = new    keyboardButton(35, false);  //G
    _map[2][6] = new    keyboardButton(36, false);  //H
    _map[2][7] = NULL;

    _map[3][0] = new    keyboardButton(37, false);  //J
    _map[3][1] = new    keyboardButton(38, false);  //K
    _map[3][2] = new    keyboardButton(39, false);  //L
    _map[3][3] = new    keyboardButton(27, false);  //@
    _map[3][4] = new    keyboardButton(28, false);  //[
    _map[3][5] = new    keyboardButton(13, false);  //^
    _map[3][6] = new    keyboardButton(14, false);  //￥
    _map[3][7] = NULL;

    _map[4][0] = new    keyboardButton(0xFF, false);    //Func(キーボード内で利用するだけでそのままキーコードを送信しない)
    _map[4][1] = new    keyboardButton(46, false);  //Z
    _map[4][2] = new    keyboardButton(47, false);  //X
    _map[4][3] = new    keyboardButton(48, false);  //C
    _map[4][4] = new    keyboardButton(49, false);  //V
    _map[4][5] = new    keyboardButton(50, false);  //B
    _map[4][6] = new    keyboardButton(51, false);  //N
    _map[4][7] = NULL;

    _map[5][0] = new    keyboardButton(52, false);  //M
    _map[5][1] = new    keyboardButton(40, false);  //;
    _map[5][2] = new    keyboardButton(41, false);  //:
    _map[5][3] = new    keyboardButton(83, false);  //↑
    _map[5][4] = new    keyboardButton(42, false);  //]
    _map[5][5] = new    keyboardButton(55, false);  //／
    _map[5][6] = new    keyboardButton(43, false);  //Enter
    _map[5][7] = NULL;

    _map[6][0] = NULL;
    _map[6][1] = new    keyboardButton(44, false);  //L-SHIFT
    _map[6][2] = new    keyboardButton(58, false);  //Ctlr
    _map[6][3] = new    keyboardButton(60, false);  //L-Alt
    _map[6][4] = new    keyboardButton(131, false); //無変換
    _map[6][5] = new    keyboardButton(61, false);  //スペース
    _map[6][6] = NULL;
    _map[6][7] = NULL;

    _map[7][0] = new    keyboardButton(53, false);  //,
    _map[7][1] = new    keyboardButton(54, false);  //.
    _map[7][2] = new    keyboardButton(79, false);  //←
    _map[7][3] = new    keyboardButton(84, false);  //↓
    _map[7][4] = new    keyboardButton(89, false);  //→
    _map[7][5] = new    keyboardButton(57, false);  //R-SHIFT
    _map[7][6] = NULL;
    _map[7][7] = NULL;

    //全てのキーボタンを未押下状態＆スキャン回数を初期化する
    reset();
}


keyboardJP53::~keyboardJP53()
{
    //newしたkeyboardButtonをdeleteする
    for (int _row = 0; _row < KEYBORAD_JP53_ROW; _row++) {
        for (int _col = 0; _col < KEYBORAD_JP53_ROW; _col++) {
            if (NULL != _map[_row][_col]) {
                delete _map[_row][_col];
            }
        }
    }
}



//全てのキーボタンを未押下状態＆スキャン回数を初期化する
void keyboardJP53::reset()
{
    _scan = 0;
    
    for (int temp = 0; temp < KEYBORAD_JP53_MAX_SCAN; temp++) {
        for (int _row = 0; _row < KEYBORAD_JP53_ROW; _row++) {
            for (int _col = 0; _col < KEYBORAD_JP53_ROW; _col++) {
                _status[temp][_row][_col] = false;
            }
        }
    }
}

//現在のスキャン回数を取得する
int keyboardJP53::scan() {
    return  _scan;
}

//最大スキャン回数を取得する
int keyboardJP53::max() {
    return  KEYBORAD_JP53_MAX_SCAN;
}


//指定RowへのCol値をスキャンする 
//--row  : 更新対象row値
//--value: col7,col6,col5,col4,col3,col2,col1,col0
void    keyboardJP53::scanRow(int row, unsigned char value) {

    //valueをstd:bitsetへ変換
    std::bitset<8> bsValue(value);

    for  ( int i=0;i<=7;i++){
        _status[_scan][row][i] = bsValue[i];
    }
}


//スキャン回数をインクリメントする
void    keyboardJP53::nextScan() {
    _scan++;
    if (_scan >= KEYBORAD_JP53_MAX_SCAN) {
        _scan = 1;
    }
}

//スキャン結果を元にキーボード押下/未押下状態を更新する
void    keyboardJP53::update(std::vector<keyboardButton>& newPressedButton, std::vector<keyboardButton>& newReleasedButton) {
    bool pressed;
    keyboardButton *button;

    //_newPressedButton,_newReleasedButtonを初期化する
    newPressedButton.clear();
    newReleasedButton.clear();
    
    for (int _row = 0; _row < KEYBORAD_JP53_ROW; _row++) {
        for (int _col = 0; _col < KEYBORAD_JP53_ROW; _col++) {

            //スキャン回数が全てTrueなら押下状態 1つでもfalseなら未押下状態とする
            pressed = true;
            for (int temp = 0; temp < KEYBORAD_JP53_MAX_SCAN; temp++) {
                pressed = pressed && _status[temp][_row][_col];
            }

            button = _map[_row][_col];
            //未定義であればコピー処理をスルー
            if (button == NULL) {
                continue;
            }

            //新規に押下されたキーボードボタンに当該ボタンをコピー
            if ((pressed) && (not button->press())) {
                newPressedButton.push_back(*button);
                button->set(true);
            }

            //新規に未押下されたキーボードボタンに当該ボタンをコピー
            if ((not pressed) && (button->press())) {
                newReleasedButton.push_back(*button);
                button->set(false);
            }

        }
    }
}

//押下中のキーボードボタンを取得する
bool    keyboardJP53::pressedButton(std::vector<keyboardButton>& result) {

    bool returnValue = false;
    keyboardButton *button;

    //resultに_newPressedButtonの要素を挿入する
    result.clear();

    for (int _row = 0; _row < KEYBORAD_JP53_ROW; _row++) {
        for (int _col = 0; _col < KEYBORAD_JP53_ROW; _col++) {
            button = _map[_row][_col];

            //未定義であればコピー処理をスルー
            if (button == NULL) {
                continue;
            }

            //押下されたキーボードボタンに当該ボタンをコピー
            if (button->press()) {
                returnValue = true;
                result.push_back(*button);
            }
        }
    }
    return  returnValue;
}

//未押下のキーボードボタンを取得する
bool    keyboardJP53::releasedButton(std::vector<keyboardButton>& result) {

    bool returnValue = false;
    keyboardButton *button;

    //resultに_newPressedButtonの要素を挿入する
    result.clear();

    for (int _row = 0; _row < KEYBORAD_JP53_ROW; _row++) {
        for (int _col = 0; _col < KEYBORAD_JP53_ROW; _col++) {
            button = _map[_row][_col];

            //未定義であればコピー処理をスルー
            if (button == NULL) {
                continue;
            }

            //押下されたキーボードボタンに当該ボタンをコピー
            if (not button->press()) {
                returnValue = true;
                result.push_back(*button);
            }
        }
    }
    return  returnValue;
}
