#ifndef KEYBOARDJP53_H
#define KEYBOARDJP53_H

#include    <vector>
#include    <bitset>
#include    "keyboardButton.h"


class keyboardJP53
{
public:
    //コンストラクタ 
    keyboardJP53();

    //デストラクタ 
    ~keyboardJP53();

    //全てのキーボタンを未押下状態＆スキャン回数を初期化する
    void    reset();

    //現在のスキャン回数を取得する
    int scan();

    //最大スキャン回数を取得する
    int max();

    //指定RowへのCol値をスキャンする 
    //--row  : 更新対象row値
    //--value: col7,col6,col5,col4,col3,col2,col1,col0
    void    scanRow( int row, unsigned char value);

    //スキャン回数をインクリメントする
    void    nextScan();

    //スキャン結果を元にキーボード押下/未押下状態を更新する
    void    update(std::vector<keyboardButton>&, std::vector<keyboardButton>&);

    //新規に押下されたキーボードボタンを取得する
    bool    pressedButton(std::vector<keyboardButton>&);

    //新規に未押下になったキーボードボタンを取得する
    bool    releasedButton(std::vector<keyboardButton>&);
    
protected:
    //最大スキャン回数
    static const int KEYBORAD_JP53_MAX_SCAN = 3;

    //スキャン対象キーマップ Row:8 * Col:8 
    static const int KEYBORAD_JP53_ROW = 8;
    static const int KEYBORAD_JP53_COL = 8;

    //現在のスキャン回数
    int _scan;  

    //キーマップ
    keyboardButton *_map[KEYBORAD_JP53_ROW][KEYBORAD_JP53_COL];  

    //スキャン回数分のキー押下状態スナップショット
    bool _status[KEYBORAD_JP53_MAX_SCAN][KEYBORAD_JP53_ROW][KEYBORAD_JP53_COL];  
   
};



#endif

