#include "mbed.h"

Serial serial ( PA_9 , NC );

//SPI conf
SPI spi ( PB_15 , PB_14 , PB_13 );
//FRAM SPI CS conf
DigitalOut fram_cs ( PB_12 );

DigitalOut led_blue ( PA_5 );
DigitalOut led_red ( PA_8 );
DigitalOut led_orange ( PA_10 );

DigitalIn pulse ( PA_2 );
DigitalIn pulse_safe ( PB_5 );
DigitalIn flow_dir ( PB_9 );
DigitalIn case_open ( PA_3 );
DigitalIn sw1 ( PB_2 );
DigitalIn sw2 ( PB_6 );
DigitalIn sw3 ( PB_7 );

int fram_rdsr = 0x01;
int bit = 0;

InterruptIn int_pa_0 ( PA_0 );

// Toggle LED
void toggle_led ()
{
    serial .printf ( "int_pa_0 happened!:\n\r" );
    wait (0.1); 
    if ( pulse == 1 )       led_blue = !led_blue;
    if ( pulse_safe == 1 )  led_red = !led_red;
    if ( flow_dir == 1 )    led_orange = !led_orange;
}
void fram_cs_free ()
{
    wait_us ( 10 ); fram_cs = 1; wait_us ( 10 );
}
void fram_cs_busy ()
{
    wait_us ( 10 ); fram_cs = 0; wait_us ( 10 );
}

int main() {

    //DIP switch pin set the mode to Pull Up
    sw1 .mode (PullUp);
    sw2 .mode (PullUp);
    sw3 .mode (PullUp);

    led_blue    = 1;
    led_red     = 1;
    led_orange  = 1;

    wait (1);
    // SPI conf
    spi.format ( 8 , 0 );
    spi.frequency ( 8000000 );

    // FRAM RDSR ( Read Status Register )
    fram_cs_busy ();
    spi.write ( 0x05 );
    fram_rdsr = spi.write ( 0x00 );
    fram_cs_free ();
    serial.printf ( "FRAM RDSR = 0x%X\n\r" , fram_rdsr );
    bit = ( fram_rdsr >> 1 ) & 1U;
    serial.printf ( "FRAM RDSR WEL bit = %u\n\r" , bit );
    
    // FRAM WRSR ( Write Status Register ) Toggle WEL bit
    fram_rdsr ^= 1UL << 1;
    fram_cs_busy ();
    if ( !bit )
        spi.write ( 0x06 ); // Set Write Enable Latch
    spi.write ( 0x01 ); // Write Status Register
    spi.write ( fram_rdsr ); // Write toggled WEL bit
    fram_cs_free ();
    serial.printf ( "Toggle WEL bit");
    
    // FRAM RDSR ( Read Status Register )
    fram_cs_busy ();
    spi.write ( 0x05 );
    fram_rdsr = spi.write ( 0x00 );
    fram_cs_free ();
    serial.printf ( "FRAM RDSR = 0x%X\n\r" , fram_rdsr );
    bit = ( fram_rdsr >> 1 ) & 1U;
    serial.printf ( "FRAM RDSR WEL bit = %u\n\r" , bit );

    // Change LEDs blinking frequency when pulse
    int_pa_0.rise ( &toggle_led );

    while ( 1 )
    {
        wait ( 5 );

        serial.printf ( "DIP switch status:\n\r" );
        ( sw1 ) ? serial .printf ( "SW1 = 1\n\r" ) : serial .printf ( "SW1 = 0\n\r" );
        ( sw2 ) ? serial .printf ( "SW2 = 1\n\r" ) : serial .printf ( "SW2 = 0\n\r" );
        ( sw3 ) ? serial .printf ( "SW3 = 1\n\r" ) : serial .printf ( "SW3 = 0\n\r" );

        serial.printf ( "Pulse status:\n\r" );
        ( pulse )       ? serial .printf ( "pulse = 1\n\r" )         : serial .printf ( "pulse = 0\n\r" );
        ( pulse_safe )  ? serial .printf ( "pulse_safe = 1\n\r" )    : serial .printf ( "pulse_safe = 0\n\r" );
        ( flow_dir )    ? serial .printf ( "flow_dir = 1\n\r" )      : serial .printf ( "flow_dir = 0\n\r" );
    }
}
