#include "mbed.h"

uint8_t temp_offset = 0xFB;
//uint8_t temp_offset = 0x00;
uint8_t hum_offset = 0x00 ;

Serial serial ( PA_9 , NC );

// IES LEDs
DigitalOut led1 ( PB_5 );
DigitalOut led2 ( PB_2 );
DigitalOut led3 ( PH_1 );

DigitalIn pulse ( PA_2 );

// I2C conf ( SDA , SCK )
I2C i2c ( PB_9 , PB_8 );

char i2c_data[1] = { 0 };
char i2c_data2[2] = { 0 , 0 };
char i2c_data4[4] = { 0 , 0 , 0 , 0 };

const int i2c_addr_read  = 129;
const int i2c_addr_write = 128;

char conf_reg[1]        = { 0x0E };
char meas_conf_reg[1]   = { 0x0F };
char manf_id_low_reg[1] = { 0xFC };
char temp_max_reg[1]    = { 0x05 };
char temp_low_reg[1]        = { 0x00 };

char conf_reg_init[2] = { 0x0F , 0x00 };
char meas_conf_reg_init[2] = { 0x0F , 0x00 };
char meas_conf_reg_reset[2] = { 0x0E , 0x80 };
char meas_conf_reg_heat_on[2] = { 0x0E , 0x08 };
char temp_offset_reg[2] = { 0x08 , temp_offset };

char meas_conf_reg_meas[2] = { 0x0F , 0x01 }; // start_meas: 14bit, t&h , meas
//char meas_conf_reg_meas[2] = { 0x0F , 0x51 }; // start_meas: 11bit, t&h , meas
//char meas_conf_reg_meas[2] = { 0x0F , 0xA1 }; // start_meas: t_8bit, h_8bit , t&h , meas

// HDC init
void hdc_init ()
{
    serial .printf ( "\n\r" );
    
    //Konfiguracja startowa rejestrów
    i2c.write ( i2c_addr_write , conf_reg_init , 2 , false );
    i2c.write ( i2c_addr_write , meas_conf_reg_init , 2 , false );
    
    // Wdrożenie offsetu
    i2c.write ( i2c_addr_write , temp_offset_reg , 2 , false );
    
    //Weryfikacja konfiguracji startowej rejestrów
    i2c.write ( i2c_addr_write , conf_reg , 1 , true );
    i2c.read ( i2c_addr_read , i2c_data , 1 , false );
    serial .printf ( "0x0E Conf. reg.: %X\n\r" , i2c_data[0] );
    i2c.write ( i2c_addr_write , meas_conf_reg , 1 , true );
    i2c.read ( i2c_addr_read , i2c_data , 1 , false );
    serial .printf ( "0x0F Meas conf. reg.: %X\n\r" , i2c_data[0] );
    
    // Weryfikacja adresu Manf. Id Low
    i2c.write ( i2c_addr_write , manf_id_low_reg , 1 , true );
    i2c.read ( i2c_addr_read , i2c_data , 1 , false );
    serial .printf ( "HDC manf_id_low_reg: %X initiated\n\r" , i2c_data[0] );
}

void hdc_soft_reset ()
{
    serial .printf ( "\n\r" );
    // Soft reset
    i2c.write ( i2c_addr_write , meas_conf_reg_reset , 2 , false );
    // Wait to perform reset
    wait ( 1 );
    serial .printf ( "Soft reset perfomed\n\r" );
}

void hdc_heater ( uint8_t t )
{
    serial .printf ( "\n\r" );
    // Soft reset
    i2c.write ( i2c_addr_write , meas_conf_reg_reset , 2 , false );
    // Wait to perform reset
    wait ( t );
    serial .printf ( "Heater switched on for 5s\n\r" );
}

void hdc_single_acqusition ()
{
    i2c.write ( i2c_addr_write , meas_conf_reg_meas , 2 , false );
    wait ( 0.2 );
    i2c.write ( i2c_addr_write , temp_low_reg , 1 , true );
    i2c.read ( i2c_addr_read , i2c_data4 , 4 , false );
    //serial .printf ( "HDC Single acquisition raw[hex] 3-0: %X , %X , %X , %X \n\r" , i2c_data4[3] , i2c_data4[2] , i2c_data4[1] , i2c_data4[0] );
    double temp = ( i2c_data4 [1] << 8 ) + i2c_data4 [0];
    temp = ( ( temp * 165 ) / 65536 ) - 40 ;
    serial .printf ( "temp: %f\n\r" , temp );
}

void hdc_temp_max ()
{
    i2c.write ( i2c_addr_write , temp_max_reg , 1 , true );
    i2c.read ( i2c_addr_read , i2c_data , 1 , false );
    //serial .printf ( "HDC Max temp. raw[hex]: %X\n\r" , i2c_data [0] );
    double temp = i2c_data [0];
    temp = ( ( temp * 165 ) / 256 ) - 40 ;
    serial .printf ( "HDC Max temp. = %f\n\r" , temp );
}

// Toggle LED
void toggle_led ()
{
    serial .printf ( "led toggle\n\r" );
    led1 = !led1;
    led3 = !led2;
    led3 = !led3;
}

int main() {

    led1 = 0;
    led2 = 0;
    led3 = 0;
    
    i2c.frequency ( 1000000 );
    
    hdc_init () ;
    //hdc_soft_reset () ;
    //hdc_heater ( 5 );
    //hdc_init () ;

    while ( 1 )
    {
        for ( int i = 0 ; i < 10 ; i++ )
        {
            hdc_single_acqusition () ;
            wait ( 10 ) ;
        }
        hdc_temp_max () ;
    }
}
