#include "mbed.h"
#include "SO1602A.h"

#define  SDA PB_7
#define  SCL PB_6

AnalogIn a4(PA_5);
AnalogIn a5(PA_6);
AnalogIn a0(PA_0);
AnalogIn a1(PA_1);
AnalogIn a2(PA_3);
AnalogIn a3(PA_4);

DigitalIn s1(D1);
DigitalIn s2(D2);
DigitalIn s3(D3);

I2C i2c(SDA,SCL);
SO1602A oled(i2c,0x78);

int main()
{
    bool s1t;
    bool s2t;
    bool s3t;
    int mode=1;
    oled.init();
    oled.setDispFlag(true,false,false);
    while(1) {
        float read;
        if(s1.read()==0) {
            if(s1t==false) {
                s1t=true;
                if(mode==1) {
                    mode=6;
                } else {
                    mode--;
                }
            }
        } else {
            s1t=false;
        }

        if(s3.read()==0) {
            if(s3t==false) {
                s3t=true;
                if(mode==6) {
                    mode=1;
                } else {
                    mode++;
                }
            }
        } else {
            s3t=false;
        }

        switch(mode) {
            case 1:
                read=a5.read();
                break;
            case 2:
                read=a3.read();
                break;
            case 3:
                read=a1.read();
                break;
            case 4:
                read=a0.read();
                break;
            case 5:
                read=a2.read();
                break;
            case 6:
                read=a4.read();
                break;
        }
        oled.locate(0,0);
        oled.printf("%d %c %f",mode,'=',read);
    }
}

/*
AnalogIn a4(PA_5);
AnalogIn a5(PA_6);
AnalogIn a0(PA_0);
AnalogIn a1(PA_1);
AnalogIn a2(PA_3);
AnalogIn a3(PA_4);

DigitalIn s1(D1);
DigitalIn s2(D2);
DigitalIn s3(D3);

I2C i2c(SDA,SCL);
SO1602A oled(i2c,0x78);


int main()
{
    bool s1t;
    bool s2t;
    bool s3t;
    int mode=1;
    int moded=1;
    int joho;
    int joho2;
    s1.mode(PullUp);
    s2.mode(PullUp);
    s3.mode(PullUp);

    while(1) {
        if(s1.read()==0) {
            if(s1t==false) {
                s1t=true;
                if(mode==1) {
                    mode=6;
                } else {
                    mode--;
                }
            }
        } else {
            s1t=false;
        }

        if(s2.read()==0) {
            if(s2t==false) {
                s2t=true;
                if(moded==1) {
                    oled.init();
                    oled.setDispFlag(true,false,false);
                    moded=2;
                } else {
                    oled.init();
                    oled.setDispFlag(true,false,false);
                    moded=1;
                }
            }
        } else {
            s2t=false;
        }

        if(s3.read()==0) {
            if(s3t==false) {
                s3t=true;
                if(mode==6) {
                    mode=1;
                } else {
                    mode++;
                }
            }
        } else {
            s3t=false;
        }
        if(moded==1) {
            float read;
            switch(mode) {
                case 1:
                    read=a5.read();
                    break;
                case 2:
                    read=a3.read();
                    break;
                case 3:
                    read=a1.read();
                    break;
                case 4:
                    read=a0.read();
                    break;
                case 5:
                    read=a2.read();
                    break;
                case 6:
                    read=a4.read();
                    break;
            }
            oled.locate(0,0);
            oled.printf("%d %c %f",mode,'=',read);
        } else {
            joho=0;
            joho2=0;
            if(a5.read()<=0.8f) {
                joho+=2;
                joho2++;
            }
            if(a3.read()<=0.8f) {
                joho+=1;
                joho2++;
            }
            if(a1.read()<=0.8f) {
                joho+=0;
                joho2++;
            }
            if(a0.read()<=0.8f) {
                joho+=0;
                joho2++;
            }
            if(a2.read()<=0.8f) {
                joho-=1;
                joho2++;
            }
            if(a4.read()<=0.8f) {
                joho-=2;
                joho2++;
            }
            if(joho2==0) {
                joho=99;
            }
            if(joho2==6) {
                joho=98;
            }
            oled.locate(0,0);
            oled.printf("%2d",joho);
        }
    }
}
*/