
#include "mbed.h"
#include "Process.h"
#include "QEI.h"

#include "../../CommonLibraries/PID/PID.h"
#include "../../Communication/RS485/ActuatorHub/ActuatorHub.h"
#include "../../Communication/RS485/LineHub/LineHub.h"
#include "../../Communication/Controller/Controller.h"
#include "../../Input/ExternalInt/ExternalInt.h"
#include "../../Input/Switch/Switch.h"
#include "../../Input/Potentiometer/Potentiometer.h"
#include "../../Input/Encoder/Encoder.h"
#include "../../LED/LED.h"
#include "../../Safty/Safty.h"
#include "../Using.h"

using namespace SWITCH;
using namespace PID_SPACE;
using namespace ENCODER;
using namespace LINEHUB;

static CONTROLLER::ControllerData *controller;
ACTUATORHUB::MOTOR::MotorStatus motor[MOUNTING_MOTOR_NUM];
ACTUATORHUB::SOLENOID::SolenoidStatus solenoid;

static bool lock;
static bool processChangeComp;
static int current;

static void AllActuatorReset();

#ifdef USE_SUBPROCESS
static void (*Process[USE_PROCESS_NUM])(void);
#endif

#pragma region USER-DEFINED_VARIABLES_AND_PROTOTYPE

/*Replace here with the definition code of your variables.*/

Serial pc(USBTX, USBRX);

//**************Encoder***************
const int PerRev = 256;
QEI ECD_0(ECD_A_0,ECD_B_0,NC,PerRev,QEI::X4_ENCODING);
QEI ECD_1(ECD_A_1,ECD_B_1,NC,PerRev,QEI::X4_ENCODING);
QEI ECD_2(ECD_A_2,ECD_B_2,NC,PerRev,QEI::X4_ENCODING);
QEI ECD_3(ECD_A_3,ECD_B_3,NC,PerRev,QEI::X4_ENCODING);
//**************Encoder***************

//**************Buzzer****************
//DigitalOut buzzer(BUZZER_PIN);
void BuzzerTimer_func();
Ticker BuzzerTimer;
bool EMGflag = false;
//PWMOut buzzer(BUZZER_PIN);
//**************Buzzer****************

//************TapeLed*****************
void TapeLedEms_func();
TapeLedData tapeLED;
TapeLedData sendLedData;
TapeLED_Mode ledMode = Normal;
Ticker tapeLedTimer;
//************TapaLed*****************

float tireProRPM[4];
float tireTarRPM[4];
float tirepwm[4];

const int omni[15][15] = {
    {    0,     5,    21,     47,     83,    130,    187,    255,    255,    255,    255,    255,    255,    255,    255 },
    {   -5,     0,     5,     21,     47,     83,    130,    187,    193,    208,    234,    255,    255,    255,    255 },
    {  -21,    -5,     0,      5,     21,     47,     83,    130,    135,    151,    177,    213,    255,    255,    255 },
    {  -47,   -21,     5,      0,      5,     21,     47,     83,     88,    104,    130,    167,    213,    255,    255 },
    {  -83,   -47,    -21,     5,      0,      5,     21,     47,     52,     68,     94,    130,    177,    234,    255 },
    { -130,   -83,    -47,    -21,     5,      0,      5,     21,     26,     42,     68,    104,    151,    208,    255 },
    { -187,  -130,    -83,    -47,    -21,    -5,      0,      5,     10,     26,     52,     88,    135,    193,    255 },
    { -255,  -187,   -130,    -83,    -47,    -21,    -5,      0,      5,     21,     47,     83,    130,    187,    255 },
    { -255,  -193,   -135,    -88,    -52,    -26,    -10,    -5,      0,      5,     21,     47,     83,    130,    187 },
    { -255,  -208,   -151,   -104,    -68,    -42,    -26,    -21,    -5,      0,      5,     21,     47,     83,    130 },
    { -255,  -234,   -177,   -130,    -94,    -68,    -52,    -47,    -21,    -7,      0,      7,     21,     47,     83 },
    { -255,  -255,   -213,   -167,   -130,   -104,    -88,    -83,    -47,    -21,    -5,      0,      5,     21,     47 },
    { -255,  -255,   -255,   -213,   -177,   -151,   -135,   -130,    -83,    -47,    -21,    -5,      0,      5,     21 },
    { -255,  -255,   -255,   -255,   -234,   -208,   -193,   -187,   -130,    -83,    -47,    -21,    -5,      0,      5 },
    { -255,  -255,   -255,   -255,   -255,   -255,   -255,   -255,   -187,   -130,    -83,    -47,   -21,     -5,      0 }
};

const int curve[15] = { -152, -98, -54, -18, 0, 0, 0, 0, 0, 0, 0, 18, 54, 98, 152 };
//{-200,-146,-102,-66,-36,-16,0,0,0,16,36,66,102,146,200}

uint8_t SetStatus(int);
uint8_t SetStatus(int pwmVal)
{
    if (pwmVal < 0) return BACK;
    else if (pwmVal > 0) return FOR;
    else if (pwmVal == 0) return BRAKE;
    else return BRAKE;
}
uint8_t Setpwm(int);
uint8_t Setpwm(int pwmVal)
{
    if (pwmVal == 0 || pwmVal >  255 || pwmVal < -255) return 255;
    else return abs(pwmVal);
}

#pragma endregion USER-DEFINED_VARIABLES_AND_PROTOTYPE

#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
static void Process0(void);
#endif
#if USE_PROCESS_NUM>1
static void Process1(void);
#endif
#if USE_PROCESS_NUM>2
static void Process2(void);
#endif
#if USE_PROCESS_NUM>3
static void Process3(void);
#endif
#if USE_PROCESS_NUM>4
static void Process4(void);
#endif
#if USE_PROCESS_NUM>5
static void Process5(void);
#endif
#if USE_PROCESS_NUM>6
static void Process6(void);
#endif
#if USE_PROCESS_NUM>7
static void Process7(void);
#endif
#if USE_PROCESS_NUM>8
static void Process8(void);
#endif
#if USE_PROCESS_NUM>9
static void Process9(void);
#endif
#endif

void SystemProcessInitialize()
{
    #pragma region USER-DEFINED_VARIABLE_INIT
    /*Replace here with the initialization code of your variables.*/
    #pragma endregion USER-DEFINED_VARIABLE_INIT

    lock = true;
    processChangeComp = true;
    current = DEFAULT_PROCESS;

#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0
    Process[0] = Process0;
#endif
#if USE_PROCESS_NUM>1
    Process[1] = Process1;
#endif
#if USE_PROCESS_NUM>2
    Process[2] = Process2;
#endif
#if USE_PROCESS_NUM>3
    Process[3] = Process3;
#endif
#if USE_PROCESS_NUM>4
    Process[4] = Process4;
#endif
#if USE_PROCESS_NUM>5
    Process[5] = Process5;
#endif
#if USE_PROCESS_NUM>6
    Process[6] = Process6;
#endif
#if USE_PROCESS_NUM>7
    Process[7] = Process7;
#endif
#if USE_PROCESS_NUM>8
    Process[8] = Process8;
#endif
#if USE_PROCESS_NUM>9
    Process[9] = Process9;
#endif
#endif
}

static void SystemProcessUpdate()
{
#ifdef USE_SUBPROCESS
    if(controller->Button.HOME) lock = false;

    if(controller->Button.START && processChangeComp) {
        current++;
        if (USE_PROCESS_NUM < current) current = USE_PROCESS_NUM;
        processChangeComp = false;
    } else if(controller->Button.SELECT && processChangeComp) {
        current--;
        if (current < 0) current = 0;
        processChangeComp = false;
    } else if(!controller->Button.SELECT && !controller->Button.START) processChangeComp = true;
#endif

#ifdef USE_MOTOR
    ACTUATORHUB::MOTOR::Motor::Update(motor);
#endif

#ifdef USE_SOLENOID
    ACTUATORHUB::SOLENOID::Solenoid::Update(solenoid);
#endif

#ifdef USE_RS485
    ACTUATORHUB::ActuatorHub::Update();
#endif

}

int g[8];

void SystemProcess()
{
    SystemProcessInitialize();

    while(1) {
        for(int i = 0; i < 8; i++) {
            g[i] = LineHub::GetPara(i);
        }

#ifdef USE_MU
        controller = CONTROLLER::Controller::GetData();
#endif

#ifdef USE_ERRORCHECK
        if(SAFTY::ErrorCheck::Check() & SAFTY::Error::ControllerLost) {
            CONTROLLER::Controller::DataReset();
            AllActuatorReset();
            lock = true;
        } else
#endif
        {

#ifdef USE_SUBPROCESS
            if(!lock) {
                Process[current]();
            } else
#endif
            {
                //ロック時の処理
            }
        }
        /*
        //Emergency!
        if(!EMG_0 && !EMG_1 && !EMGflag) {
            buzzer = 0;
            BuzzerTimer.attach(BuzzerTimer_func, 1);
            EMGflag = true;
            LED_DEBUG0 = 1;
        }
        if(EMG_0 && EMG_1 && EMGflag) {
            buzzer = 1;
            BuzzerTimer.detach();
            EMGflag = false;
        }
        */
        SystemProcessUpdate();
    }
}


int Twsh;

#pragma region PROCESS
#ifdef USE_SUBPROCESS
#if USE_PROCESS_NUM>0

static void Process0()
{
    if(StertSW) {
        current = 2;
        Twsh=3;
    }
}
#endif

#if USE_PROCESS_NUM>1

bool dz1=true;
bool dz1i=false;
bool dz2=true;
bool dz2i=false;
bool dz3=true;
bool dz3i=false;
bool dz4=true;
bool dz4i=false;

bool zone;
bool through=false;

int mode =1;
int cross=0;//十字数える用
int count=100000;//wait代替え
int slow=30;


static void Process1()
{
    count=100000;
    mode=0;
    cross=0;
    motor[TIRE_FR].dir = SetStatus(-omni[controller->AnalogL.Y][14-controller->AnalogL.X]     + curve[controller->AnalogR.X]);
    motor[TIRE_FL].dir = SetStatus(omni[controller->AnalogL.Y][controller->AnalogL.X]         + curve[controller->AnalogR.X]);
    motor[TIRE_BR].dir = SetStatus(-omni[14-controller->AnalogL.X][14-controller->AnalogL.Y]  + curve[controller->AnalogR.X]);
    motor[TIRE_BL].dir = SetStatus(omni[controller->AnalogL.X][14-controller->AnalogL.Y]      + curve[controller->AnalogR.X]);

    motor[TIRE_FR].pwm = Setpwm(omni[controller->AnalogL.Y][14-controller->AnalogL.X]+ curve[controller->AnalogR.X])*0.2;
    motor[TIRE_FL].pwm = Setpwm(omni[controller->AnalogL.Y][controller->AnalogL.X]+ curve[controller->AnalogR.X])*0.2;
    motor[TIRE_BR].pwm = Setpwm(omni[14-controller->AnalogL.X][14-controller->AnalogL.Y]+ curve[controller->AnalogR.X])*0.2;
    motor[TIRE_BL].pwm = Setpwm(omni[controller->AnalogL.X][14-controller->AnalogL.Y]+ curve[controller->AnalogR.X])*0.2;

    if(controller->Button.UP||controller->Button.DOWN) {

        if(controller->Button.UP) {
            motor[MOTOR_0].pwm = 110;
            motor[MOTOR_0].dir = FOR;
        }
        if(controller->Button.DOWN) {
            motor[MOTOR_0].pwm = 50;
            motor[MOTOR_0].dir = BACK;
        }
    } else {
        motor[MOTOR_0].pwm = 0;
        motor[MOTOR_0].dir = BRAKE;
    }
    if(controller->Button.X) {
        if(dz1==true) {
            if(dz1i==false) {
                solenoid.solenoid1 = SOLENOID_ON;
                dz1i=true;
            } else {
                solenoid.solenoid1 = SOLENOID_OFF;
                dz1i=false;
            }
            dz1=false;
        }
    } else {
        dz1=true;
    }

    if(controller->Button.Y) {
        if(dz2==true) {
            if(dz2i==false) {
                solenoid.solenoid2 = SOLENOID_ON;
                dz2i=true;
            } else {
                solenoid.solenoid2 = SOLENOID_OFF;
                dz2i=false;
            }
            dz2=false;
        }
    } else {
        dz2=true;
    }

    if(controller->Button.A) {
        if(dz3==true) {
            if(dz3i==false) {

                dz3i=true;
            } else {
                solenoid.solenoid3 = SOLENOID_OFF;
                dz3i=false;
            }
            dz3=false;
        }
    } else {
        dz3=true;
    }

    if(controller->Button.B) {
        if(dz4==true) {
            if(dz4i==false) {
                solenoid.solenoid4 = SOLENOID_ON;
                dz4i=true;
            } else {
                solenoid.solenoid4 = SOLENOID_OFF;
                dz4i=false;
            }
            dz4=false;
        }
    } else {
        dz4=true;
    }
    /*
    if(controller->Button.RIGHT){
     motor[MOTOR_1].dir = FOR;
     motor[MOTOR_1].pwm = 60;
     if (ARM_1){
      motor[MOTOR_1].dir = BRAKE;
     }
    }
    else if(controller->Button.LEFT){
     motor[MOTOR_1].dir = BACK;
     motor[MOTOR_1].pwm = 60;
     if (ARM_0){
      motor[MOTOR_1].dir = BRAKE;
     }
    }
    */
}
#endif

#if USE_PROCESS_NUM>2
bool mtc=false;
//追加
bool mtc2 = false;

static void Process2()
{
 //   printf("1:%d 2:%d 3:%d 4:%d 5:%d 6:%d 7:%d 8:%d\n\r",g[0],g[1],g[2],g[3],g[4],g[5],g[6],g[7]);
    count++;
    if(mode==0&&StertSW) {
        if(ThSW) {
            zone=ZoneSW;
            Twsh=1;
            mode=1;
        } else {
            zone=ZoneSW;
            Twsh=2;
            mode=1;
        }
    }
    if(ZoneSW==false) {
        if(mode==1) {//スタートゾーンから白線検知
            motor[TIRE_FR].pwm = 30;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = 30;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 30;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 30;
            motor[TIRE_BL].dir = FOR;
            if(g[2]==0) {
                count=100000;
                cross=0;
                mode=2;
            }
        } else if(mode==2) {//横移動
            if(g[2]==0) {
                count=100000;
                cross=0;
                mode=3;
                mtc2=true;
            } else {
                motor[TIRE_FR].pwm = 30;
                motor[TIRE_FR].dir = FOR;
                motor[TIRE_FL].pwm = 30;
                motor[TIRE_FL].dir = FOR;
                motor[TIRE_BR].pwm = 30;
                motor[TIRE_BR].dir = BACK;
                motor[TIRE_BL].pwm = 30;
                motor[TIRE_BL].dir = BACK;
            }
        } else if(mode==3) { //横ライントレースから縦ライントレースへ
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = slow;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = slow;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(g[0]==0) {
                through=true;
            }
            if(through==true&&g[0]==255) {
                through=false;
                count=0;
                mode=4;
            }
        } else if(mode==4) { //横ライントレースから縦ライントレースへ
            motor[TIRE_FR].pwm = slow;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = slow;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = slow;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = slow;
            motor[TIRE_BL].dir = FOR;
            if(g[0]==0) {
                count=0;
                cross=0;
                mode=10;
            }
        } else if(g[0]!=99&&mode==10) { //縦ライントレース
            switch(g[0]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    if(count>100000) {
                        cross++;
                        count=0;
                    }
                    mtc=true;
                    if(cross==Twsh) {
                        mode=11;
                        count=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[0]!=98&&mtc==true) {
                switch(g[1]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_BR].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_BR].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_BR].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_BL].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_BL].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_BR].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==11) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = slow;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = slow;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(g[2]==0) {
                through=true;
            }
            if(through==true&&g[2]==255) {
                through=false;
                mode=12;
            }
        } else if(mode==12) {
            motor[TIRE_FR].pwm = slow;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = slow;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = slow;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = slow;
            motor[TIRE_BL].dir = BACK;
            if(g[2]==0) {
                count=0;
                cross=0;
                mode=20;
            }
        } else if(mode==20) {
            switch(g[2]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    if(count>70000) {
                        cross++;
                        count=0;
                    }
                    mtc2=true;
                    if(cross==3) {
                        mode=21;
                        count=0;
                        cross=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
            }
            if(g[2]!=98&&mtc2==true) {
                switch(g[3]) {
                    case 0:
                        mtc2=false;
                        break;
                    case 255:
                        motor[TIRE_BL].pwm += 5;
                        mtc2=false;
                        break;
                    case 253:
                        motor[TIRE_BL].pwm += 10;
                        mtc2=false;
                        break;
                    case 254:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc2=false;
                        break;
                    case 1:
                        motor[TIRE_FL].pwm += 5;
                        mtc2=false;
                        break;
                    case 3:
                        motor[TIRE_FL].pwm += 10;
                        mtc2=false;
                        break;
                    case 2:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc2=false;
                        break;
                }
            }
        } else if(mode==21) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = slow;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = slow;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(g[0]==0) {
                through=true;
            }
            if(through==true&&g[0]==255) {
                through=false;
                mode=22;
            }
        } else if(mode==22) {
            motor[TIRE_FR].pwm = slow;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = slow;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = slow;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = slow;
            motor[TIRE_BL].dir = FOR;
            if(g[0]==0) {
                solenoid.solenoid3 = SOLENOID_ON;
                count=0;
                cross=0;
                mode=30;
            }
        } else if(mode==30) {
            switch(g[0]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    if(count>100000) {
                        cross++;
                        count=0;
                    }
                    mtc=true;
                    if(cross==1) {
                        solenoid.solenoid3 = SOLENOID_OFF;
                        mode=31;
                        count=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[0]!=98&&mtc==true) {
                switch(g[1]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_BR].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_BR].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_BR].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_BL].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_BL].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_BR].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==31) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = 0;
            motor[TIRE_FL].dir = FREE;
            motor[TIRE_BR].pwm = 0;
            motor[TIRE_BR].dir = FREE;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = FOR;
            if(count>5000&&g[3]==0) {
                count=0;
                mode=32;
            }
        } else if(mode==32) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = BACK;
            if(count>5000&&g[3]==0) {
                count=0;
                cross=0;
                mode=40;
            }
        } else if(mode==40) {
            switch(g[3]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    if(count>30000) {
                        cross++;
                        count=0;
                    }
                    mtc2=true;
                    if(cross==1) {
                        mode=41;
                        count=0;
                        cross=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
            }
            if(g[2]!=98&&mtc2==true) {
                switch(g[2]) {
                    case 0:
                        mtc2=false;
                        break;
                    case 255:
                        motor[TIRE_FL].pwm += 5;
                        mtc2=false;
                        break;
                    case 253:
                        motor[TIRE_FL].pwm += 10;
                        mtc2=false;
                        break;
                    case 254:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc2=false;
                        break;
                    case 1:
                        motor[TIRE_BL].pwm += 5;
                        mtc2=false;
                        break;
                    case 3:
                        motor[TIRE_BL].pwm += 10;
                        mtc2=false;
                        break;
                    case 2:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc2=false;
                        break;
                }
            }
        } else if(mode==41) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=42;
            }
        } else if(mode==42) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = BACK;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=50;
            }
        } else if(mode==50) {
            switch(g[1]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    if(count>100000) {
                        cross++;
                        count=0;
                    }
                    mtc=true;
                    if(cross==1) {
                        mode=51;
                        count=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[1]!=98&&mtc==true) {
                switch(g[0]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_FL].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_FL].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_FR].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_FR].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_FR].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_FR].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==51) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>5000&&g[3]==0) {
                count=0;
                mode=52;
            }
        } else if(mode==52) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = FOR;
            if(count>5000&&g[3]==0) {
                count=0;
                cross=0;
                mode=60;
            }
        } else if(mode==60) {
            switch(g[3]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    if(count>50000) {
                        cross++;
                        count=0;
                    }
                    mtc2=true;
                    if(cross==2) {
                        mode=61;
                        count=0;
                        cross=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
            }
            if(g[2]!=98&&mtc2==true) {
                switch(g[2]) {
                    case 0:
                        mtc2=false;
                        break;
                    case 255:
                        motor[TIRE_FL].pwm += 5;
                        mtc2=false;
                        break;
                    case 253:
                        motor[TIRE_FL].pwm += 10;
                        mtc2=false;
                        break;
                    case 254:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc2=false;
                        break;
                    case 1:
                        motor[TIRE_BL].pwm += 5;
                        mtc2=false;
                        break;
                    case 3:
                        motor[TIRE_BL].pwm += 10;
                        mtc2=false;
                        break;
                    case 2:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc2=false;
                        break;
                }
            }
        } else if(mode==61) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=62;
            }
        } else if(mode==62) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = BACK;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=70;
            }
        } else if(mode==70) {
            switch(g[1]) {
                case 99:
                    if(count>=100000) {
                        mode=100;
                    }
                    break;
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[1]!=98&&mtc==true) {
                switch(g[0]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_FL].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_FL].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_FR].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_FR].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_FR].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_FR].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==100) {
            motor[TIRE_FR].pwm = 20;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 20;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 23;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 20;
            motor[TIRE_BL].dir = BACK;
        } else {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = BRAKE;
            motor[TIRE_FL].pwm = 0;
            motor[TIRE_FL].dir = BRAKE;
            motor[TIRE_BR].pwm = 0;
            motor[TIRE_BR].dir = BRAKE;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = BRAKE;
        }
    } else {//////////////////////////////////////////////////これより別ゾーン用/////////////////////////////////////////////////////////////////////////////////
        if(mode==1) {//スタートゾーンから白線検知
            motor[TIRE_FR].pwm = 30;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 30;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 30;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 30;
            motor[TIRE_BL].dir = BACK;
            if(g[2]==0) {
                count=100000;
                cross=0;
                mode=2;
            }
        } else if(mode==2) {//横移動
            if(g[2]==0) {
                count=100000;
                cross=0;
                mode=3;
                mtc2=true;
            } else {
                motor[TIRE_FR].pwm = 30;
                motor[TIRE_FR].dir = FOR;
                motor[TIRE_FL].pwm = 30;
                motor[TIRE_FL].dir = FOR;
                motor[TIRE_BR].pwm = 30;
                motor[TIRE_BR].dir = BACK;
                motor[TIRE_BL].pwm = 30;
                motor[TIRE_BL].dir = BACK;
            }
        } else if(mode==3) { //横ライントレースから縦ライントレースへ
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 20;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 20;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>100000&&g[0]==0) {
                count=0;
                mode=10;
            }
        } else if(mode==4) { //横ライントレースから縦ライントレースへ
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = FOR;
            if(count>30000&&g[0]==0) {
                count=0;
                cross=0;
                mode=10;
            }
        } else if(g[0]!=99&&mode==10) { //縦ライントレース
            switch(g[0]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    if(count>100000) {
                        cross++;
                        count=0;
                    }
                    mtc=true;
                    if(cross==Twsh) {
                        mode=11;
                        count=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[0]!=98&&mtc==true) {
                switch(g[1]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_BL].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_BL].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_BR].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_BR].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_BR].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_BR].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==11) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>5000&&g[2]==0) {
                count=0;
                mode=12;
            }
        } else if(mode==12) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = BACK;
            if(count>10000&&g[2]==0) {
                count=0;
                cross=0;
                mode=20;
            }
        } else if(mode==20) {
            switch(g[2]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    if(count>70000) {
                        cross++;
                        count=0;
                    }
                    mtc2=true;
                    if(cross==3) {
                        mode=21;
                        count=0;
                        cross=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    mtc2=true;
                    break;
            }
            if(g[2]!=98&&mtc2==true) {
                switch(g[3]) {
                    case 0:
                        mtc2=false;
                        break;
                    case 255:
                        motor[TIRE_BL].pwm += 5;
                        mtc2=false;
                        break;
                    case 253:
                        motor[TIRE_BL].pwm += 10;
                        mtc2=false;
                        break;
                    case 254:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc2=false;
                        break;
                    case 1:
                        motor[TIRE_FL].pwm += 5;
                        mtc2=false;
                        break;
                    case 3:
                        motor[TIRE_FL].pwm += 10;
                        mtc2=false;
                        break;
                    case 2:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc2=false;
                        break;
                }
            }
        } else if(mode==21) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>2000&&g[0]==0) {
                count=0;
                mode=22;
            }
        } else if(mode==22) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = FOR;
            if(count>5000&&g[0]==0) {
                count=0;
                cross=0;
                mode=30;
            }
        } else if(mode==30) {
            switch(g[0]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    if(count>100000) {
                        cross++;
                        count=0;
                    }
                    mtc=true;
                    if(cross==1) {
                        mode=31;
                        count=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = FOR;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = BACK;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[0]!=98&&mtc==true) {
                switch(g[1]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_BL].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_BL].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_BR].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_BR].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_BR].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_BR].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==31) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = 0;
            motor[TIRE_FL].dir = FREE;
            motor[TIRE_BR].pwm = 0;
            motor[TIRE_BR].dir = FREE;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = FOR;
            if(count>5000&&g[3]==0) {
                count=0;
                mode=32;
            }
        } else if(mode==32) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = BACK;
            if(count>5000&&g[3]==0) {
                count=0;
                cross=0;
                mode=40;
            }
        } else if(mode==40) {
            switch(g[3]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    if(count>30000) {
                        cross++;
                        count=0;
                    }
                    mtc2=true;
                    if(cross==1) {
                        mode=41;
                        count=0;
                        cross=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
            }
            if(g[2]!=98&&mtc2==true) {
                switch(g[2]) {
                    case 0:
                        mtc2=false;
                        break;
                    case 255:
                        motor[TIRE_FL].pwm += 5;
                        mtc2=false;
                        break;
                    case 253:
                        motor[TIRE_FL].pwm += 10;
                        mtc2=false;
                        break;
                    case 254:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc2=false;
                        break;
                    case 1:
                        motor[TIRE_BL].pwm += 5;
                        mtc2=false;
                        break;
                    case 3:
                        motor[TIRE_BL].pwm += 10;
                        mtc2=false;
                        break;
                    case 2:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc2=false;
                        break;
                }
            }
        } else if(mode==41) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=42;
            }
        } else if(mode==42) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = BACK;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=50;
            }
        } else if(mode==50) {
            switch(g[1]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    if(count>100000) {
                        cross++;
                        count=0;
                    }
                    mtc=true;
                    if(cross==1) {
                        mode=51;
                        count=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[1]!=98&&mtc==true) {
                switch(g[0]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_FR].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_FR].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_FR].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_FL].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_FL].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_FR].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==51) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>5000&&g[3]==0) {
                count=0;
                mode=52;
            }
        } else if(mode==52) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = BACK;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = FOR;
            if(count>5000&&g[3]==0) {
                count=0;
                cross=0;
                mode=60;
            }
        } else if(mode==60) {
            switch(g[3]) {
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    if(count>50000) {
                        cross++;
                        count=0;
                    }
                    mtc2=true;
                    if(cross==2) {
                        mode=61;
                        count=0;
                        cross=0;
                    }
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc2=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = BACK;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = FOR;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc2=true;
                    break;
            }
            if(g[2]!=98&&mtc2==true) {
                switch(g[2]) {
                    case 0:
                        mtc2=false;
                        break;
                    case 255:
                        motor[TIRE_FL].pwm += 5;
                        mtc2=false;
                        break;
                    case 253:
                        motor[TIRE_FL].pwm += 10;
                        mtc2=false;
                        break;
                    case 254:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_BL].pwm = 0;
                        mtc2=false;
                        break;
                    case 1:
                        motor[TIRE_BL].pwm += 5;
                        mtc2=false;
                        break;
                    case 3:
                        motor[TIRE_BL].pwm += 10;
                        mtc2=false;
                        break;
                    case 2:
                        motor[TIRE_BL].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc2=false;
                        break;
                }
            }
        } else if(mode==61) {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = FREE;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = FREE;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=62;
            }
        } else if(mode==62) {
            motor[TIRE_FR].pwm = 15;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 15;
            motor[TIRE_FL].dir = FOR;
            motor[TIRE_BR].pwm = 15;
            motor[TIRE_BR].dir = BACK;
            motor[TIRE_BL].pwm = 15;
            motor[TIRE_BL].dir = BACK;
            if(count>5000&&g[1]==0) {
                count=0;
                mode=70;
            }
        } else if(mode==70) {
            switch(g[1]) {
                case 99:
                    if(count>=100000) {
                        mode=100;
                    }
                    break;
                case 98:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    break;
                case 0:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 255:
                    motor[TIRE_FR].pwm = 60;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 40;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 40;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 60;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 253:
                    motor[TIRE_FR].pwm = 20;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 20;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 254:
                    motor[TIRE_FR].pwm = 30;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 0;
                    motor[TIRE_FL].dir = FREE;
                    motor[TIRE_BR].pwm = 0;
                    motor[TIRE_BR].dir = FREE;
                    motor[TIRE_BL].pwm = 30;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 1:
                    motor[TIRE_FR].pwm = 40;
                    motor[TIRE_FR].dir = BACK;
                    motor[TIRE_FL].pwm = 60;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 60;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 40;
                    motor[TIRE_BL].dir = FOR;
                    mtc=true;
                    break;
                case 3:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 20;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 20;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
                case 2:
                    motor[TIRE_FR].pwm = 0;
                    motor[TIRE_FR].dir = FREE;
                    motor[TIRE_FL].pwm = 30;
                    motor[TIRE_FL].dir = FOR;
                    motor[TIRE_BR].pwm = 30;
                    motor[TIRE_BR].dir = BACK;
                    motor[TIRE_BL].pwm = 0;
                    motor[TIRE_BL].dir = FREE;
                    mtc=true;
                    break;
            }
            if(g[1]!=98&&mtc==true) {
                switch(g[0]) {
                    case 0:
                        mtc=false;
                        break;
                    case 255:
                        motor[TIRE_FR].pwm += 5;
                        mtc=false;
                        break;
                    case 253:
                        motor[TIRE_FR].pwm += 10;
                        mtc=false;
                        break;
                    case 254:
                        motor[TIRE_FR].pwm += 20;
                        motor[TIRE_FL].pwm = 0;
                        mtc=false;
                        break;
                    case 1:
                        motor[TIRE_FL].pwm += 5;
                        mtc=false;
                        break;
                    case 3:
                        motor[TIRE_FL].pwm += 10;
                        mtc=false;
                        break;
                    case 2:
                        motor[TIRE_FL].pwm += 20;
                        motor[TIRE_FR].pwm = 0;
                        mtc=false;
                        break;
                }
            }
        } else if(mode==100) {
            motor[TIRE_FR].pwm = 20;
            motor[TIRE_FR].dir = FOR;
            motor[TIRE_FL].pwm = 20;
            motor[TIRE_FL].dir = BACK;
            motor[TIRE_BR].pwm = 23;
            motor[TIRE_BR].dir = FOR;
            motor[TIRE_BL].pwm = 20;
            motor[TIRE_BL].dir = BACK;
        } else {
            motor[TIRE_FR].pwm = 0;
            motor[TIRE_FR].dir = BRAKE;
            motor[TIRE_FL].pwm = 0;
            motor[TIRE_FL].dir = BRAKE;
            motor[TIRE_BR].pwm = 0;
            motor[TIRE_BR].dir = BRAKE;
            motor[TIRE_BL].pwm = 0;
            motor[TIRE_BL].dir = BRAKE;
        }
    }

}

#endif

#if USE_PROCESS_NUM>3
static void Process3()
{

}
#endif

#if USE_PROCESS_NUM>4
static void Process4()
{

}
#endif

#if USE_PROCESS_NUM>5
static void Process5()
{

}
#endif

#if USE_PROCESS_NUM>6
static void Process6()
{

}
#endif

#if USE_PROCESS_NUM>7
static void Process7()
{

}
#endif

#if USE_PROCESS_NUM>8
static void Process8()
{

}
#endif

#if USE_PROCESS_NUM>9
static void Process9()
{

}
#endif
#endif
#pragma endregion PROCESS

static void AllActuatorReset()
{

#ifdef USE_SOLENOID
    solenoid.all = ALL_SOLENOID_OFF;
#endif

#ifdef USE_MOTOR
    for (uint8_t i = 0; i < MOUNTING_MOTOR_NUM; i++) {
        motor[i].dir = FREE;
        motor[i].pwm = 0;
    }
#endif
}

/*
void BuzzerTimer_func()
{
    buzzer = !buzzer;
    //LED_DEBUG0 = !LED_DEBUG0;
}
*/
void TapeLedEms_func()
{
    sendLedData.code = sendLedData.code == (uint32_t)Red ? (uint32_t)Black : (uint32_t)Red;
}

#pragma region USER-DEFINED-FUNCTIONS


#pragma endregion
