#include "RS485.h"
#include "mbed.h"
#include "ActuatorHub/ActuatorHub.h"
#include "LineHub/LineHub.h"
#include "../../LED/LED.h"
#include "../../System/Using.h"

namespace RS485 {
    
    DigitalOut selectBitT(SELECTBIT_T_PIN);
//  DigitalOut selectBitR(SELECTBIT_R_PIN);
    Serial RS485Uart(RS485UART_TX, RS485UART_RX);
    Serial RS485Line(RS485LINE_TX, RS485LINE_RX);
    
    bool readFase = 0;
    char buffer[RS485_BUFFER_LINE] = {0};

    void Transmit();
    void Recieve();

    void RS485::Initialize() {
        selectBitT = 1;  //送信固定
//      selectBitR = 0;  //受信固定
        RS485Uart.baud(38400);
        RS485Uart.attach(Transmit, Serial::TxIrq);  //送信割り込み
        RS485Line.baud(9600);
        RS485Line.attach(Recieve, Serial::RxIrq);  //受信割り込み
    }

    void Transmit() {
//        __disable_irq();
        static uint8_t count = 0;
        RS485Uart.putc(RS485SendBuffer.GetData());
        if(count >= 200) {
            #ifdef USE_MOTOR
            LED_DEBUG2 = !LED_DEBUG2;
            #endif

            count = 0;
        } else count++;
        __enable_irq();
    }
    
    void Recieve() {
        __disable_irq();
        static uint8_t time = 0;
        static uint8_t count = 0;
        char data = RS485Line.getc();
        if (data == 'S') {
            readFase = true;
            time = 0;
        } else if(data == 'F') {
            readFase = false;
            for(int i = 0; i < 8; i++) {
                lineData[i] = buffer[i];
            }
            time = 0;
        } else if(readFase) {
            RS485LineBuffer.PutData(data);
            buffer[time] = data;
            time++;
        } else {
            readFase = false;
            time = 0;
        }
        if(count >= 200) {
            LED_DEBUG1 = !LED_DEBUG1;
            count = 0;
        } else count++;
        __enable_irq();
    }
}