#include "mbed.h"
#include "RingBuffer.h"
#include "SO1602A.h"

//********** pin define **********//
#define  SELECT1_0  PB_4
#define  SELECT1_1  PB_5
#define  SELECT1_2  PB_3
#define  SELECT1_3  PB_1
#define  SELECT2_0  PF_0
#define  SELECT2_1  PF_1
#define  SELECT2_2  PA_8
#define  SELECT2_3  PA_11
#define  SELECT3_0  PA_4
#define  SELECT3_1  PA_5
#define  SELECT3_2  PA_7
#define  SELECT3_3  PA_6
#define  Z0         PA_0
#define  Z1         PA_1
#define  Z2         PA_3
#define  SDA        PB_7
#define  SCL        PB_6
#define  UART_SE    PA_2
#define  UARTTX     PA_9
#define  UARTRX     PA_10
//********** pin define **********//

//********** pin select **********//
AnalogIn y1(Z0);
AnalogIn y2(Z1);
AnalogIn y3(Z2);

DigitalOut select1[]= {
    DigitalOut(SELECT1_0),
    DigitalOut(SELECT1_1),
    DigitalOut(SELECT1_2),
    DigitalOut(SELECT1_3),
};
DigitalOut select2[]= {
    DigitalOut(SELECT2_0),
    DigitalOut(SELECT2_1),
    DigitalOut(SELECT2_2),
    DigitalOut(SELECT2_3),
};
DigitalOut select3[]= {
    DigitalOut(SELECT3_0),
    DigitalOut(SELECT3_1),
    DigitalOut(SELECT3_2),
    DigitalOut(SELECT3_3),
};

DigitalOut uartSE(UART_SE);
 
DigitalOut LED(LED3);

//pcとマイコンの通信設定[湯アートがマイコン]

//Serial uart(USBTX,USBRX);
Serial uart(UARTTX,UARTRX);

I2C i2c(SDA,SCL);
SO1602A oled(i2c,0x78);

//********** pin select **********//

//********** define **********//
#define  BUFFER_SIZE  10
char RS485Data[BUFFER_SIZE];
RINGBUFFER::RingBuffer RS485uart(RS485Data,BUFFER_SIZE);

#define  SENDDATA_SIZE    8
#define  SENSORDATA_SIZE  48

const int pinDef[48] = { 0, 1, 2, 3, 4, 5,
                         12,13,14,15, 7, 6,
                         22,23, 8, 9,10,11,
                         16,17,18,19,20,21,
                         27,26,25,24,40,41,
                         28,29,30,31,38,39,
                         32,33,34,35,36,37,
                         42,43,44,45,36,47
                       };

const int weight[6] = { 2, 1, 0, 0,-1,-2};

char send[SENDDATA_SIZE] = {60,77,80,55,65,68,90,87};
bool line[SENSORDATA_SIZE] = {0};

void Transmit();
void PinSelect(int pin);
void SendDataUpdate(char sendData[], int dataSize);
void LineDataRead(bool sensorData[], int dataSize);
void SendDataMake(bool sensorData[], char sendData[]);
//********** define **********//

void InitiaLize(void)
{
    uartSE = 1; //送信固定

    uart.baud(9600);
    uart.attach(Transmit,Serial::TxIrq);
}

int main(void)
{
    InitiaLize();
    //oled.init();
    //oled.setDispFlag(true,false,false);
    while(1) {
        /*
        if(send[2]>250) {
            oled.locate(0,0);
            oled.printf("%d",send[2]-256);
        } else {
            oled.locate(0,0);
            oled.printf("%2d",send[2]);
        }
        if(send[3]>250) {
            oled.locate(5,0);
            oled.printf("%d",send[3]-256);
        } else {
            oled.locate(5,0);
            oled.printf("%2d",send[3]);
        }
        */
        LineDataRead(line,SENSORDATA_SIZE);
        SendDataMake(line,send);
        SendDataUpdate(send,SENDDATA_SIZE);
    }
}

void Transmit()
{
    __disable_irq();
    // uart.printf("%d\n\r",RS485uart.GetData());
    uart.putc(RS485uart.GetData());
    __enable_irq();

}

void SendDataUpdate(char sendData[], int dataSize)
{
    __disable_irq();
    if(!RS485uart.InAnyData()) {
        RS485uart.PutData('S');
        for(int i = 0; i < dataSize; i++) {
            RS485uart.PutData(sendData[i]);
        }
        RS485uart.PutData('F');
    }
    __enable_irq();
}

void PinSelect(int pin)
{
    bool selectnum[16][4]= {
        {0,0,0,0},
        {0,0,0,1},
        {0,0,1,0},
        {0,0,1,1},
        {0,1,0,0},
        {0,1,0,1},
        {0,1,1,0},
        {0,1,1,1},
        {1,0,0,0},
        {1,0,0,1},
        {1,0,1,0},
        {1,0,1,1},
        {1,1,0,0},
        {1,1,0,1},
        {1,1,1,0},
        {1,1,1,1},
    };
    if(pin < 16) {
        select1[0]=selectnum[pin][3];
        select1[1]=selectnum[pin][2];
        select1[2]=selectnum[pin][1];
        select1[3]=selectnum[pin][0];
        for(int i=0; i<=3; i++) {
            select2[i]=0;
            select3[i]=0;
        }
    } else if(pin < 32) {
        select2[0]=selectnum[pin-16][3];
        select2[1]=selectnum[pin-16][2];
        select2[2]=selectnum[pin-16][1];
        select2[3]=selectnum[pin-16][0];
        for(int i=0; i<=3; i++) {
            select1[i]=0;
            select3[i]=0;
        }
    } else if(pin < 48) {
        select3[0]=selectnum[pin-32][3];
        select3[1]=selectnum[pin-32][2];
        select3[2]=selectnum[pin-32][1];
        select3[3]=selectnum[pin-32][0];
        for(int i=0; i<=3; i++) {
            select1[i]=0;
            select2[i]=0;
        }
    }
}

void LineDataRead(bool sensorData[], int dataSize)
{
    int pin;
    float readData = 0;
    for(int i = 0; i < dataSize; i++) {
        pin = pinDef[i];
        PinSelect(pin);
        if(pin<=15) {
            readData = y1.read();
        } else if(pin<=31) {
            readData = y2.read();
        } else if(pin<=47) {
            readData = y3.read();
        }
        //uart.printf("%d:%f\n\r",i,readData);
        if(readData < 0.8f) {     
            sensorData[i] = 0;
        } else {
            sensorData[i] = 1;
        }

    }
}

void SendDataMake(bool sensorData[], char sendData[])
{
    int data = 0;
    bool ACflag = true;
    bool NCflag = true;
    int count = 0;
    for(int i = 0; i < 8; i++) {
        NCflag = true;
        ACflag = true;
        data = 0;
        for(int j = 0; j < 6; j++) {
            data += (!sensorData[count]) * weight[j];
            if(sensorData[count] == 1) ACflag = false;
            else if(sensorData[count] == 0) NCflag = false;
            count++;
        }
        if(NCflag) sendData[i] = 99;
        else if(ACflag) sendData[i] = 98;
        else sendData[i] = data;
    }
}