#ifndef LED_H_
#define LED_H_

#include "mbed.h"
#include <stdint.h>

namespace LED {
    extern DigitalOut boardLED[];

    #define LED_ON  0
    #define LED_OFF 1

    // BOARD_DEBUG_LED
    #define LED_DEBUG0_PIN  PD_2
    #define LED_DEBUG1_PIN  PC_12
    #define LED_DEBUG2_PIN  PA_15
    #define LED_MU_PIN      PB_7

    #define LED_DEBUG0  LED::boardLED[0]
    #define LED_DEBUG1  LED::boardLED[1]
    #define LED_DEBUG2  LED::boardLED[2]
    #define LED_MU      LED::boardLED[3]
    
    // LED
    #define LED_TAPE0_PIN  PC_2 
    #define LED_TAPE1_PIN  PC_3
    #define LED_TAPE2_PIN  PC_0
    #define LED_TAPE3_PIN  PC_1
    #define LED_TAPE4_PIN  PB_0
    
    class LED {
        public:
        static void Initialize();
        static void TapeledMode(uint8_t index);
    };
}

#endif
