#include "LED.h"

#include "../System/Using.h"
#include "mbed.h"
#include <stdint.h>

namespace LED {
    DigitalOut boardLED[USE_LED_NUM] = {
        DigitalOut(LED_DEBUG0_PIN),
        DigitalOut(LED_DEBUG1_PIN),
        DigitalOut(LED_DEBUG2_PIN),
        DigitalOut(LED_MU_PIN),
    };
    
    DigitalOut tapeLED[] = {
        DigitalOut(LED_TAPE0_PIN),
        DigitalOut(LED_TAPE1_PIN),
        DigitalOut(LED_TAPE2_PIN),
        DigitalOut(LED_TAPE3_PIN),
        DigitalOut(LED_TAPE4_PIN),
    };

    void LED::Initialize() {
        for(uint8_t i = 0; i < USE_LED_NUM; i++) {
            boardLED[i] = LED_OFF;
        }
        for(uint8_t i = 0; i < USE_TAPELED_NUM; i++) {
            tapeLED[i] = LED_OFF;
        }
    }
    
    void LED::TapeledMode(uint8_t index) {
        for(uint8_t i = 0; i < USE_TAPELED_NUM; i++) {
            tapeLED[i] = (index >> i) & 0x01;
        }
    }
}
