#include "LED.h"

#include "../System/Using.h"
#include "mbed.h"
#include <stdint.h>

namespace LED {
    DigitalOut boardLED[USE_LED_NUM] = {
        DigitalOut(LED_DEBUG0_PIN),
        DigitalOut(LED_DEBUG1_PIN),
        DigitalOut(LED_DEBUG2_PIN),
        DigitalOut(LED_MU_PIN),
    };
    
    DigitalOut tapeLED[USE_TAPELED_NUM] = {
        DigitalOut(LED_TAPE0_PIN),
        DigitalOut(LED_TAPE1_PIN),
        DigitalOut(LED_TAPE2_PIN),
        DigitalOut(LED_TAPE3_PIN),
        DigitalOut(LED_TAPE4_PIN),
    };

    void LED::Initialize() {
        for(uint8_t i = 0; i < USE_LED_NUM; i++) {
            boardLED[i] = LED_OFF;
        }
        for(uint8_t i = 0; i < USE_TAPELED_NUM; i++) {
            tapeLED[i] = LED_OFF;
        }
    }
    
    void LED::TapeledMode(uint8_t index) {
        int selectnum[16][4]= {
        //1,2,4,8
        {0,0,0,0},
        {1,0,0,0},
        {0,1,0,0},
        {1,1,0,0},
        {0,0,1,0},
        {1,0,1,0},
        {0,1,1,0},
        {1,1,1,0},
        {0,0,0,1},
        {1,0,0,1},
        {0,1,0,1},
        {1,1,0,1},
        {0,0,1,1},
        {1,0,1,1},
        {0,1,1,1},
        {1,1,1,1}
        };
        
        for(uint8_t i = 0; i < USE_TAPELED_NUM; i++) {
            tapeLED[i] = selectnum[index][i];
        }
    }
}
