#include "mbed.h"
#include "LineHub.h"
#include "../../../CommonLibraries/RingBuffer/RingBuffer.h"
#include "../../../System/Process/Process.h"
#include "../../../System/Using.h"

static char RS485Line[RS485_BUFFER_LINE];
RINGBUFFER::RingBuffer RS485LineBuffer = RINGBUFFER::RingBuffer(RS485Line, RS485_BUFFER_LINE);

int lineData[8];

namespace LINEHUB {
    
    
    void LineHub::Initialize() {
        for(int i = 0; i < 8; i++) {
            lineData[i] = 0;
        }
        
    }
    
    void LineHub::Update() {
        if(RS485LineBuffer.IsFullup()) {
            for(int i = 0; i < 8; i++) {
                lineData[i] = (int)RS485LineBuffer.GetData();
            }
        }
    }
    
    int LineHub::GetPara(int num) {
        return lineData[num];
    }
}