#ifndef SWITCH_H_
#define SWITCH_H_

#include "mbed.h"
#include <stdint.h>

namespace SWITCH {
    
    #define SW_ON   0
    #define SW_OFF  1

    //DipSwitch
    #define DIP0_PIN    PA_4
    #define DIP1_PIN    PA_6
    #define DIP2_PIN    PA_7
    #define DIP3_PIN    PC_7
    
    #define DIP0    dipSw[0]
    #define DIP1    dipSw[1]
    #define DIP2    dipSw[2]
    #define DIP3    dipSw[3]
    
    //DigitalInput
    #define INPUT0_PIN  PB_9     // INPUT18
    #define INPUT1_PIN  PC_9     // INPUT0
    #define INPUT2_PIN  PC_6     // INPUT2
    #define INPUT3_PIN  PA_12    // INPUT4
    #define INPUT4_PIN  PB_12    // INPUT6
    #define INPUT5_PIN  PB_1     // INPUT8
    #define INPUT6_PIN  PB_14    // INPUT10
    #define INPUT7_PIN  PC_4     // INPUT12
    #define INPUT8_PIN  PB_4     // INPUT14
    #define INPUT9_PIN  PA_8     // INPUT16
    #define INPUT10_PIN PB_6     // INPUT19
    #define INPUT11_PIN PB_8     // INPUT1
    #define INPUT12_PIN PC_8     // INPIT3
    #define INPUT13_PIN PC_5     // INPUT5
    #define INPUT14_PIN PA_11    // INPUT7
    #define INPUT15_PIN PB_2     // INPUT9
    #define INPUT16_PIN PB_15    // INPUT11
    #define INPUT17_PIN PB_13    // INPUT13
    #define INPUT18_PIN PB_5     // INPUT15
    #define INPUT19_PIN PB_10    // INPUT17
    
    #define INPUT_NUM 20
    
    class DipSw {
        public:
        static void Initialize();
        static uint8_t GetStatus();
    };
    
    class LimitSw {
        public:
        static void Initialize();
        static bool IsPressed(uint8_t index);
    };
}

#endif
