#ifndef CONTROLLER_H_
#define CONTROLLER_H_

#include <stdint.h>

namespace CONTROLLER {
    #define MU_TX PA_0
    #define MU_RX PA_1
    
    #define CTR_DATA_LENGTH 4
    #define CTR_DEFAULT_DATA {0x00, 0x00, 0x77, 0x77}

	typedef union 
	{
		struct {
			struct {
				unsigned int X:1;
				unsigned int A:1;
				unsigned int B:1;
				unsigned int Y:1;
				unsigned int UP:1;
				unsigned int RIGHT:1;
				unsigned int DOWN:1;
				unsigned int LEFT:1;
				unsigned int SELECT:1;
				unsigned int HOME:1;
				unsigned int START:1;
				unsigned int ZL:1;
				unsigned int ZR:1;
				unsigned int L:1;
				unsigned int R:1;
				unsigned int :1;
			} __attribute__ ((packed)) Button;
			struct {
				unsigned int Y:4;
				unsigned int X:4;
			} __attribute__ ((packed)) AnalogL;
			struct {
				unsigned int Y:4;
				unsigned int X:4;
			} __attribute__ ((packed)) AnalogR;
		} __attribute__ ((packed)) ;
		uint8_t buf[CTR_DATA_LENGTH];		
	}ControllerData;
    
    class Controller
    {
        public:
            static void Initialize(void);
            static ControllerData* GetData(void);
            static void DataReset(void);
            static bool CheckControllerLost(void);
    };
}

#endif
