#include "Switch.h"

#include <stdint.h>
#include "mbed.h"

namespace SWITCH {
    DigitalIn dipSw[] = {
        DigitalIn(DIP0_PIN),
        DigitalIn(DIP1_PIN),
        DigitalIn(DIP2_PIN),
        DigitalIn(DIP3_PIN),
    };
    
    DigitalIn digitalIn[INPUT_NUM] = {
        DigitalIn(INPUT0_PIN),
        DigitalIn(INPUT1_PIN),
        DigitalIn(INPUT2_PIN),
        DigitalIn(INPUT3_PIN),
        DigitalIn(INPUT4_PIN),
        DigitalIn(INPUT5_PIN),
        DigitalIn(INPUT6_PIN),
        DigitalIn(INPUT7_PIN),
        DigitalIn(INPUT8_PIN),
        DigitalIn(INPUT9_PIN),
        DigitalIn(INPUT10_PIN),
        DigitalIn(INPUT11_PIN),
        DigitalIn(INPUT12_PIN),
        DigitalIn(INPUT13_PIN),
        DigitalIn(INPUT14_PIN),
        DigitalIn(INPUT15_PIN),
        DigitalIn(INPUT16_PIN),
        DigitalIn(INPUT17_PIN),
        DigitalIn(INPUT18_PIN),
        DigitalIn(INPUT19_PIN),
    };

    void DipSw::Initialize() {
        for(uint8_t i=0; i < sizeof(dipSw)/sizeof(dipSw[0]); i++) {
            dipSw[i].mode(PullUp);
        }
    }

    uint8_t DipSw::GetStatus() {
        if(DIP0 == SW_ON)       return 0;
        else if(DIP1 == SW_ON)  return 1;
        else if(DIP2 == SW_ON)  return 2;
        else if(DIP3 == SW_ON)  return 3;

        return 0;
    }

    void LimitSw::Initialize() {
        for(uint8_t i = 0; i < INPUT_NUM; i++) {
            digitalIn[i].mode(PullUp);
        }
    }

    bool LimitSw::IsPressed(uint8_t index) {
        return digitalIn[index] ? false : true;
    }
}
