#include "Switch.h"

#include <stdint.h>
#include "mbed.h"

namespace SWITCH {
    DigitalIn dipSw[] = {
        DigitalIn(DIP0_PIN),
        DigitalIn(DIP1_PIN),
        DigitalIn(DIP2_PIN),
        DigitalIn(DIP3_PIN),
    };

    DigitalIn limitSw(LS_PIN);
    
    DigitalOut selectPin[] = {
        DigitalOut(SELECT0_PIN),
        DigitalOut(SELECT1_PIN),
        DigitalOut(SELECT2_PIN),
        DigitalOut(SELECT3_PIN),
    };

    void DipSw::Initialize() {
        for(uint8_t i=0; i < sizeof(dipSw)/sizeof(dipSw[0]); i++) {
            dipSw[i].mode(PullUp);
        }
    }

    uint8_t DipSw::GetStatus() {
        if(DIP0 == SW_ON)       return 0;
        else if(DIP1 == SW_ON)  return 1;
        else if(DIP2 == SW_ON)  return 2;
        else if(DIP3 == SW_ON)  return 3;

        return 0;
    }

    void LimitSw::Initialize() {
        for(uint8_t i=0; i<4; i++) selectPin[i] = 0;
        limitSw.mode(PullUp);
    }

    bool LimitSw::IsPressed(int index) {

        MP_Channel ch;
        
        switch(index){
            case 0:
            ch.all = 8;
            break;
            case 1:
            ch.all = 9;
            break;
            case 2:
            ch.all = 10;
            break;
            case 3:
            ch.all = 11;
            break;
            case 4:
            ch.all = 7;
            break;
            case 5:
            ch.all = 4;
            break;
            case 6:
            ch.all = 2;
            break;
            case 7:
            ch.all = 0;
            break;
            case 8:
            ch.all = 6;
            break;
            case 9:
            ch.all = 5;
            break;
            case 10:
            ch.all = 3;
            break;
            case 11:
            ch.all = 1;
            break;
            case 12:
            ch.all = 12;
            break;
            case 13:
            ch.all = 13;
            break;
            case 14:
            ch.all = 14;
            break;
            case 15:
            ch.all = 15;
            break;
        }
        

        selectPin[0] = ch.s0;
        selectPin[1] = ch.s1;
        selectPin[2] = ch.s2;
        selectPin[3] = ch.s3;
        
        wait_us(1);

        return limitSw ? false : true;
    }
}
