#ifndef PROCESS_H_
#define PROCESS_H_

#include "mbed.h"

#define BUZZER_PIN PA_5
#define EMG_0 LimitSw::IsPressed(0)
#define EMG_1 LimitSw::IsPressed(1)

void SystemProcess();

#define TIRE_FL 0
#define TIRE_BL 1
#define TIRE_BR 2
#define TIRE_FR 3
#define MOTOR_0 4

#define StertSW LimitSw::IsPressed(9) //スタートスイッチ
#define ZoneSW  LimitSw::IsPressed(6) //赤・青ゾーン用スイッチ
#define ThSW    LimitSw::IsPressed(4) //シーツタオルスイッチ
#define DWSW    LimitSw::IsPressed(1) //上下機構上移動スイッチ
#define DOSW    LimitSw::IsPressed(3) //上下機構下移動スイッチ
#define AIRSW    LimitSw::IsPressed(2) //上下機構トリガー
#define UPLS    LimitSw::IsPressed(8) //上下機構リミット１
#define UPLS2    LimitSw::IsPressed(0) //上下機構リミット２
#define YELLOW    LimitSw::IsPressed(10) //掛けるときのライントレース切り替え
#define LIF    LimitSw::IsPressed(11) //フェンス用リミット１
#define LIB    LimitSw::IsPressed(7) //フェンス用リミット２
#define DOLS    LimitSw::IsPressed(5) //上下機構下部リミット


typedef union
{
    struct
    {
        unsigned int blue : 8;
        unsigned int green : 8;
        unsigned int red : 8;
        unsigned int : 8;
    };
    uint32_t code;
} TapeLedData;

enum TapeLED_Mode
{
    EMS,
    Normal,
    Launch,
};

enum TapeLED_Color
{
    Black                   = 0x000000,
    // Red                  = 0xff0000,
    Green                   = 0x008000,
    Blue                    = 0x0000ff,
    White                   = 0xffffff,
    // Orange                   = 0xffa500,
    // Yellow                   = 0xffff00,
    // Purple                   = 0x800080,
    // Cyan                 = 0x00ffff,
    // Magenta                  = 0xff00ff,
    // Lime                 = 0x00ff00


    Dimgray                 = 0x696969,
    Gray                    = 0x808080,
    DarkGray                = 0xa9a9a9,
    Silver                  = 0xc0c0c0,
    LightGray               = 0xd3d3d3,
    Gainsboro               = 0xdcdcdc,
    Whitesmoke              = 0xf5f5f5,
    Snow                    = 0xfffafa,
    Ghostwhite              = 0xf8f8ff,
    Floralwhite             = 0xfffaf0,
    Linen                   = 0xfaf0e6,
    Antiquewhite            = 0xfaebd7,
    Papayawhip              = 0xffefd5,
    Blanchedalmond          = 0xffebcd,
    Bisque                  = 0xffe4c4,
    Moccasin                = 0xffe4b5,
    Navajowhite             = 0xffdead,
    Peachpuff               = 0xffdab9,
    Mistyrose               = 0xffe4e1,
    Lavenderblush           = 0xfff0f5,
    Seashell                = 0xfff5ee,
    Oldlace                 = 0xfdf5e6,
    Ivory                   = 0xfffff0,
    Honeydew                = 0xf0fff0,
    Mintcream               = 0xf5fffa,
    Azure                   = 0xf0ffff,
    Aliceblue               = 0xf0f8ff,
    Lavender                = 0xe6e6fa,
    Lightsteelblue          = 0xb0c4de,
    Lightslategray          = 0x778899,
    Slategray               = 0x708090,
    Steelblue               = 0x4682b4,
    Royalblue               = 0x4169e1,
    Midnightblue            = 0x191970,
    Navy                    = 0x000080,
    Darkblue                = 0x00008b,
    Mediumblue              = 0x0000cd,
    Dodgerblue              = 0x1e90ff,
    Cornflowerblue          = 0x6495ed,
    Deepskyblue             = 0x00bfff,
    Lightskyblue            = 0x87cefa,
    Skyblue                 = 0x87ceeb,
    Lightblue               = 0xadd8e6,
    Powderblue              = 0xb0e0e6,
    Paleturquoise           = 0xafeeee,
    // Lightcyan                = 0xe0ffff,
    Cyan                    = 0x00ffff,
    // Aqua                 = 0x00ffff,
    Turquoise               = 0x40e0d0,
    Mediumturquoise         = 0x48d1cc,
    Darkturquoise           = 0x00ced1,
    Lightseagreen           = 0x20b2aa,
    Cabetblue               = 0x5f9ea0,
    Darkcyan                = 0x008b8b,
    Teal                    = 0x008080,
    Darkslategray           = 0x2f4f4f,
    Darkgreen               = 0x006400,
    Forestgreen             = 0x228b22,
    Seagreen                = 0x2e8b57,
    Mediumseagreen          = 0x3cb371,
    Mediumaquamarine        = 0x66cdaa,
    Darkseagreen            = 0x8fbc8f,
    Aquamarine              = 0x7fffd4,
    Palegreen               = 0x98fb98,
    Lightgreen              = 0x90ee90,
    Springgreen             = 0x00ff7f,
    Mediumspringgreen       = 0x00fa9a,
    Lawngreen               = 0x7cfc00,
    Chartreuse              = 0x7fff00,
    Greenyellow             = 0xadff2f,
    Lime                    = 0x00ff00,
    Limegreen               = 0x32cd32,
    Yellowgreen             = 0x9acd32,
    Darkolivegreen          = 0x556b2f,
    Olivedrab               = 0x6b8e23,
    Olive                   = 0x808000,
    Darkkhaki               = 0xbdb76b,
    Palegoldenrod           = 0xeee8aa,
    Cornsilk                = 0xfff8dc,
    Beige                   = 0xf5f5dc,
    Lightyellow             = 0xffffe0,
    Lightgoldenrodyellow    = 0xfafad2,
    Lemonchiffon            = 0xfffacd,
    Wheat                   = 0xf5deb3,
    Burlywood               = 0xdeb887,
    Tan                     = 0xd2b48c,
    Khaki                   = 0xf0e68c,
    Yellow                  = 0xffff00,
    Gold                    = 0xffd700,
    // Orange                   = 0xffa500,
    Orange                  = 0xff2500,
    Sandybrown              = 0xf4a460,
    Darkorange              = 0xff8c00,
    Goldenrod               = 0xdaa520,
    Peru                    = 0xcd853f,
    Darkgoldenrod           = 0xb8860d,
    Chocolate               = 0xd2691e,
    Sienna                  = 0xa0522d,
    Saddlebrown             = 0x8b4513,
    Marron                  = 0x800000,
    Darkred                 = 0x8b0000,
    Brown                   = 0xa52a2a,
    Firebrick               = 0xb22222,
    Indeanred               = 0xcd5c5c,
    Rosybrown               = 0xbc8f8f,
    Darksalmon              = 0xe9967a,
    Lightcoral              = 0xf08080,
    Salmon                  = 0xfa8072,
    Lightsalmon             = 0xffa07a,
    Coral                   = 0xff7f50,
    Tomato                  = 0xff6347,
    Orangered               = 0xff4500,
    Red                     = 0xff0000,
    Crimson                 = 0xdc143c,
    Mediumvioletred         = 0xc71585,
    Deeppink                = 0xff1493,
    Hotpink                 = 0xff69b4,
    Palevioletred           = 0xdb7093,
    Pink                    = 0xffc0cb,
    Lightpink               = 0xffb6c1,
    Thistle                 = 0xd8bfd8,
    Magenta                 = 0xff00ff,
    // Fuchsia                  = 0xff00ff,
    Violet                  = 0xee82ee,
    Plum                    = 0xdda0dd,
    Orchid                  = 0xda70d6,
    Mediumorchid            = 0xba55d3,
    Darkorchid              = 0x9932cc,
    Darkviolet              = 0x9400d3,
    Darkmagenta             = 0x8b008b,
    Purple                  = 0x800080,
    Indigo                  = 0x4b0082,
    Darkslateblue           = 0x483d8b,
    Blueviolet              = 0x8a2be2,
    Mediumpurple            = 0x9370db,
    Slateblue               = 0x6a5acd,
    Mediumslateblue         = 0x7b68ee
};

extern TapeLedData sendLedData;

#endif
