/*********************************************************************
 * Railuino - Hacking your Märklin
 *
 * Copyright (C) 2012 Joerg Pleumann
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * LICENSE file for more details.
 */
 
#include "TrackReporterS88_DS.h"

// ===================================================================
// === TrackReporterS88_DS ==============================================
// ===================================================================
	
const int TIME = 50;

DigitalOut do_load(PB_5);
DigitalOut do_reset(PB_4);
DigitalOut do_clock(PB_3);
DigitalIn di_data(PA_0);

TrackReporterS88_DS::TrackReporterS88_DS(int modules) {
	mSize = modules;

}

void TrackReporterS88_DS::refresh()
{
	refresh(mSize);
}

void TrackReporterS88_DS::refresh(int inMaxSize)
{
	int myByte = 0;
	int myBit = 0;

	
	for (int i = 0; i < sizeof(mSwitches); i++) {
		mSwitches[i] = 0;
	}

	//digitalWrite(LOAD, HIGH);
	do_load = 1;
	wait_us( TIME);
	do_clock = 1;
	//digitalWrite(CLOCK, HIGH);
	wait_us(TIME);
	do_clock = 0;
	//digitalWrite(CLOCK, LOW);
	wait_us(TIME);
	do_reset = 1;
	//digitalWrite(RESET, HIGH);
	wait_us(TIME);
	do_reset = 0;
	//digitalWrite(RESET, LOW);
	wait_us(TIME);
	//digitalWrite(LOAD, LOW);
	do_load = 0;
	
	wait_us(TIME / 2);
	bitWrite(mSwitches[myByte], myBit++, di_data);
	wait_us(TIME / 2);

	for (int i = 1; i < 16 * inMaxSize; i++) {
		//digitalWrite(CLOCK, HIGH);
		do_clock = 1;
		wait_us(TIME);
		do_clock = 0;
		//digitalWrite(CLOCK, LOW);

		wait_us(TIME / 2);
		bitWrite(mSwitches[myByte], myBit++, di_data);

		if (myBit == 8) {
			myByte++;
			myBit = 0;
		}

		wait_us(TIME / 2);
	}
	
}

boolean TrackReporterS88_DS::getValue(int index) {
	index--;
	return bitRead(mSwitches[index / 8], index % 8);
}

byte TrackReporterS88_DS::getByte(int index) {
	return mSwitches[index];
}
