#include "mbed.h"
 
Serial evy1(p9, p10); // tx, rx configured for LPC800-MAX
//Serial evy1(PTA2, PTA1); // tx, rx configured for FRDM-KL25Z
 
// DO NOT EDIT!!
const char* phoneticSymbols[] = {
    "a", "i", "M", "e", "o",        // あいうえお0-4
    "k a", "k' i", "k M", "k e", "k o", // かきくけこ5-9
    "s a", "S i", "s M", "s e", "s o", // さしすえそ10-14
    "t a", "tS i", "ts M", "t e", "t o",    // たちつてと15-19
    "n a", "J i", "n M", "n e", "n o",  //なにぬねの20-24
    "h a", "C i", "p\\ M", "h e", "h o",    // はひふへほ25-29
    "m a", "m' i", "m M", "m e", "m o", // まみむめも30-34
    "j a","i", "j M","e","j o",//やいゆえよ35-39
    "4 a", "4' i", "4 M", "4 e", "4 o", // らりるれろ40-44
    "w a","w o","N\\","","",// わをん 45-49
    "g a", "g' i", "g M", "g e", "g o",//がぎぐげご　50-54
    "dz a", "dZ i", "dz M", "dz e", "dz o",//ざじずぜぞ55-59
    "d a", "dZ i", "dz M", "d e", "d o",//だじづでど60-64
    "b a", "b' i", "b M", "b e", "b o",//ばびぶべぼ  65-69
        "p a", "p' i", "p M", "p e", "p o"//ぱぴぷぺぽ70-74
}; 
 
//lylics
//さんまのうたがきこえてくるよ
int lylics[]={10,47,30,24,2,15,50,6,9,3,18,7,42,39};
char mml[] ="CDEFEDC EFGAGFE";
 
void Short_Message(int cmd, int d1, int d2) {
  evy1.putc(cmd);
  evy1.putc(d1);
  evy1.putc(d2);
}
 
// send lylics
void lylic_send(int num){
  //hedaer
  evy1.putc(0xF0);
  evy1.putc(0x43);
  evy1.putc(0x79);
  evy1.putc(0x09);
  evy1.putc(0x00);
  evy1.putc(0x50);
  evy1.putc(0x10);
  
  for(int i=0;i<num;i++){
    if(i != 0) evy1.putc(0x2c); // 0x2c is separator
    evy1.printf(phoneticSymbols[lylics[i]]);
  }
  //footer
  evy1.putc(0x00);  // footer for NSX-1
  evy1.putc(0xF7);  // footer of MIDI sys-ex
}
 
 
int main() {
  int key = 0x3c; //C
 
  evy1.baud(31250); // MIDI speed
  wait(5); // waiting for eVY1 module boot up
 while(1)
 {
  //send lylics
  int lylic_len = sizeof(lylics) / sizeof(lylics[0]);
  lylic_send(lylic_len);    // sending lylics first
 
  int mml_len = sizeof(mml) / sizeof(mml[0]);
  
  for(int i = 0;i< mml_len ;i++){
    char c = mml[i];
    if(c >= 'a' && c <='z') c-= 0x20;
    if((c>='A' && c<='Z')||c=='<'||c=='>'){
       //key send
       if(i!=0){
         Short_Message(0x90,key,0x7f);   
         wait(0.5);
       }
       key= 0x3c; 
 
        switch(c) {
            case 'C': break;
            case 'D': key+=2; break;
            case 'E': key+=4; break;
            case 'F': key+=5; break;
            case 'G': key+=7; break;
            case 'A': key+=9; break;
            case 'B': key+=11; break;
            default: break;
        }
    }
  }
  Short_Message(0x90,key,0x7f);   // note on message. 0x90=1ch, 0x7f=Velocity
  wait(0.5);
 }
}
 